/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import java.util.Arrays;
import java.util.List;

public class JedisPluginConfig {
    private boolean enable = true;
    private boolean pipeline = true;
    private boolean io = true;

    public JedisPluginConfig(ProfilerConfig src) {
        this.enable = this.readBoolean(src, Arrays.asList("profiler.redis.jedis.enable", "profiler.redis.enable", "profiler.redis"), true);
        this.pipeline = this.readBoolean(src, Arrays.asList("profiler.redis.jedis.pipeline", "profiler.redis.pipeline"), true);
        this.io = this.readBoolean(src, Arrays.asList("profiler.redis.jedis.io", "profiler.redis.io"), true);
    }

    private boolean readBoolean(ProfilerConfig src, List<String> nameList, boolean defaultValue) {
        for (String name : nameList) {
            String value = src.readString(name, null);
            if (value == null) continue;
            return src.readBoolean(name, defaultValue);
        }
        return defaultValue;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isPipeline() {
        return this.pipeline;
    }

    public boolean isIo() {
        return this.io;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("enable=").append(this.enable);
        sb.append(", pipeline=").append(this.pipeline);
        sb.append(", io=").append(this.io);
        sb.append('}');
        return sb.toString();
    }
}

