/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.postgresql;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.postgresql.PostgreSqlConfig;
import com.navercorp.pinpoint.plugin.jdbc.postgresql.PostgreSqlConstants;
import com.navercorp.pinpoint.plugin.jdbc.postgresql.PostgreSqlJdbcUrlParser;
import java.security.ProtectionDomain;
import java.util.List;

public class PostgreSqlPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String POSTGRESQL_SCOPE = "POSTGRESQL_JDBC";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final JdbcUrlParserV2 jdbcUrlParser = new PostgreSqlJdbcUrlParser();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        PostgreSqlConfig config = new PostgreSqlConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("PostgreSql plugin is not executed because plugin enable value is false.");
            return;
        }
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addDriverTransformer();
        this.addConnectionTransformers(config);
        this.addStatementTransformers(config);
        this.addPreparedStatementTransformers(config);
        this.addLegacyConnectionTransformers(config);
        this.addLegacyStatementTransformers(config);
    }

    private void addDriverTransformer() {
        this.transformTemplate.transform("org.postgresql.Driver", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2", VarArgs.va((Object[])new Object[]{PostgreSqlConstants.POSTGRESQL, false}), PostgreSqlPlugin.POSTGRESQL_SCOPE, ExecutionPolicy.ALWAYS);
                return target.toBytecode();
            }
        });
    }

    private void addConnectionTransformers(final PostgreSqlConfig config) {
        this.transformTemplate.transform("org.postgresql.jdbc.PgConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[]{"org.postgresql.util.HostSpec[]", "java.lang.String", "java.lang.String", "java.util.Properties", "java.lang.String"}).addInterceptor("com.navercorp.pinpoint.plugin.jdbc.postgresql.interceptor.PostgreSQLConnectionCreateInterceptor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                if (config.isProfileSetAutoCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                }
                if (config.isProfileCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                }
                if (config.isProfileRollback()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                }
                return target.toBytecode();
            }
        });
    }

    private void addStatementTransformers(final PostgreSqlConfig config) {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                String executeQueryInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                if (!declaredMethods.isEmpty()) {
                    target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                    target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                    int maxBindValueSize = config.getMaxSqlBindValueSize();
                    String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                    if (config.isTraceSqlBindValue()) {
                        for (InstrumentMethod method : declaredMethods) {
                            method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE, ExecutionPolicy.BOUNDARY);
                        }
                    }
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("org.postgresql.jdbc.PgStatement", transformer);
    }

    private void addPreparedStatementTransformers(final PostgreSqlConfig config) {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                if (!declaredMethods.isEmpty()) {
                    target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                    target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                    int maxBindValueSize = config.getMaxSqlBindValueSize();
                    String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                    if (config.isTraceSqlBindValue()) {
                        for (InstrumentMethod method : declaredMethods) {
                            method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE, ExecutionPolicy.BOUNDARY);
                        }
                    }
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("org.postgresql.jdbc.PgPreparedStatement", transformCallback);
    }

    private void addLegacyConnectionTransformers(final PostgreSqlConfig config) {
        this.transformTemplate.transform("org.postgresql.jdbc2.AbstractJdbc2Connection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                if (config.isProfileSetAutoCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                }
                if (config.isProfileCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                }
                if (config.isProfileRollback()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.postgresql.jdbc3.AbstractJdbc3Connection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                return target.toBytecode();
            }
        });
        TransformCallback concreteConnectionTransformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[]{"org.postgresql.util.HostSpec[]", "java.lang.String", "java.lang.String", "java.util.Properties", "java.lang.String"}).addInterceptor("com.navercorp.pinpoint.plugin.jdbc.postgresql.interceptor.PostgreSQLConnectionCreateInterceptor");
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("org.postgresql.jdbc3.Jdbc3Connection", concreteConnectionTransformCallback);
        this.transformTemplate.transform("org.postgresql.jdbc3g.Jdbc3gConnection", concreteConnectionTransformCallback);
        this.transformTemplate.transform("org.postgresql.jdbc4.Jdbc4Connection", concreteConnectionTransformCallback);
        this.transformTemplate.transform("org.postgresql.jdbc42.Jdbc42Connection", concreteConnectionTransformCallback);
    }

    private void addLegacyStatementTransformers(final PostgreSqlConfig config) {
        this.transformTemplate.transform("org.postgresql.jdbc2.AbstractJdbc2Statement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                int maxBindValueSize = config.getMaxSqlBindValueSize();
                String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String executeQueryInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE, ExecutionPolicy.BOUNDARY);
                    }
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.postgresql.jdbc3.AbstractJdbc3Statement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", PostgreSqlPlugin.POSTGRESQL_SCOPE);
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

