/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.vertx.HttpClientRequestClientHeaderAdaptor;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import io.vertx.core.http.HttpClientRequest;

public class HttpClientImplDoRequestInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final RequestTraceWriter<HttpClientRequest> requestTraceWriter;

    public HttpClientImplDoRequestInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.methodDescriptor = descriptor;
        HttpClientRequestClientHeaderAdaptor clientHeaderAdaptor = new HttpClientRequestClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        HttpClientRequest resultToRequest = null;
        if (this.validate(result)) {
            resultToRequest = (HttpClientRequest)result;
        }
        HttpClientRequest request = resultToRequest;
        if (!trace.canSampled()) {
            if (request != null) {
                this.requestTraceWriter.write((Object)request);
            }
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            recorder.recordException(throwable);
            recorder.recordServiceType(VertxConstants.VERTX_HTTP_CLIENT_INTERNAL);
            String hostAndPort = this.toHostAndPort(args);
            if (hostAndPort != null) {
                recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, hostAndPort);
                if (this.isDebug) {
                    this.logger.debug("Set hostAndPort {}", (Object)hostAndPort);
                }
            }
            if (request != null) {
                AsyncContext asyncContext = recorder.recordNextAsyncContext();
                ((AsyncContextAccessor)request)._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set asyncContext {}", (Object)asyncContext);
                }
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean validate(Object result) {
        if (result == null || !(result instanceof HttpClientRequest)) {
            if (this.isDebug) {
                this.logger.debug("Invalid result object. result={}.", result);
            }
            return false;
        }
        if (!(result instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid result object. Need metadata accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    private String toHostAndPort(Object[] args) {
        if (args != null && (args.length == 5 || args.length == 6)) {
            if (args[1] instanceof String && args[2] instanceof Integer) {
                String host = (String)args[1];
                int port = (Integer)args[2];
                return HostAndPort.toHostAndPortString((String)host, (int)port);
            }
        } else if (args != null && args.length == 7 && args[2] instanceof String && args[3] instanceof Integer) {
            String host = (String)args[2];
            int port = (Integer)args[3];
            return HostAndPort.toHostAndPortString((String)host, (int)port);
        }
        if (this.isDebug) {
            this.logger.debug("Invalid args[]. args={}.", args);
        }
        return null;
    }
}

