/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.thrift.ThriftClientCallContext;
import com.navercorp.pinpoint.plugin.thrift.ThriftConstants;
import com.navercorp.pinpoint.plugin.thrift.ThriftRequestProperty;
import com.navercorp.pinpoint.plugin.thrift.ThriftUtils;
import com.navercorp.pinpoint.plugin.thrift.descriptor.ThriftServerEntryMethodDescriptor;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor;
import java.net.Socket;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class TProtocolReadMessageEndInterceptor
implements AroundInterceptor {
    private final ThriftServerEntryMethodDescriptor thriftServerEntryMethodDescriptor = new ThriftServerEntryMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final InterceptorScope scope;

    public TProtocolReadMessageEndInterceptor(TraceContext traceContext, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.scope = scope;
        this.traceContext.cacheApi((MethodDescriptor)this.thriftServerEntryMethodDescriptor);
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        InterceptorScopeInvocation currentTransaction;
        Object attachment;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.validate(target)) {
            return;
        }
        boolean shouldTrace = ((ServerMarkerFlagFieldAccessor)target)._$PINPOINT$_getServerMarkerFlag();
        if (shouldTrace && (attachment = (currentTransaction = this.scope.getCurrentInvocation()).getAttachment()) instanceof ThriftClientCallContext) {
            ThriftClientCallContext clientCallContext = (ThriftClientCallContext)attachment;
            try {
                this.recordTrace(target, clientCallContext);
            }
            catch (Throwable t) {
                this.logger.warn("Error creating trace object. Cause:{}", (Object)t.getMessage(), (Object)t);
            }
        }
    }

    private boolean validate(Object target) {
        if (!(target instanceof TProtocol)) {
            return false;
        }
        if (!(target instanceof ServerMarkerFlagFieldAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ServerMarkerFlagFieldAccessor.class.getName());
            }
            return false;
        }
        TTransport transport = ((TProtocol)target).getTransport();
        if (!(transport instanceof SocketFieldAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)SocketFieldAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    private void recordTrace(Object target, ThriftClientCallContext clientCallContext) {
        String methodName = clientCallContext.getMethodName();
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            ThriftRequestProperty parentTraceInfo = clientCallContext.getTraceHeader();
            this.logger.debug("parentTraceInfo : {}", (Object)parentTraceInfo);
            trace = this.createTrace(target, parentTraceInfo, methodName);
            clientCallContext.setEntryPoint(true);
        }
        if (trace == null) {
            return;
        }
        if (!trace.canSampled()) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(ThriftConstants.THRIFT_SERVER_INTERNAL);
    }

    private Trace createTrace(Object target, ThriftRequestProperty parentTraceInfo, String methodName) {
        boolean shouldSample = this.checkSamplingFlag(parentTraceInfo);
        if (!shouldSample) {
            if (this.isDebug) {
                this.logger.debug("Disable sampling flag given from remote. Skipping trace for method:{}", (Object)methodName);
            }
            return this.traceContext.disableSampling();
        }
        TraceId traceId = this.populateTraceIdThriftHeader(parentTraceInfo);
        if (traceId != null) {
            Trace trace = this.traceContext.continueTraceObject(traceId);
            if (trace.canSampled()) {
                this.recordRootSpan(trace, parentTraceInfo, target);
                if (this.isDebug) {
                    this.logger.debug("TraceId exists - continue trace. TraceId:{}, method:{}", (Object)traceId, (Object)methodName);
                }
            } else if (this.isDebug) {
                this.logger.debug("TraceId exists, canSampled is false - skip trace. TraceId:{}, method:{}", (Object)traceId, (Object)methodName);
            }
            return trace;
        }
        Trace trace = this.traceContext.newTraceObject();
        if (trace.canSampled()) {
            this.recordRootSpan(trace, parentTraceInfo, target);
            if (this.isDebug) {
                this.logger.debug("TraceId does not exist - start new trace. Method:{}", (Object)methodName);
            }
        } else if (this.isDebug) {
            this.logger.debug("TraceId does not exist, canSampled is false - skip trace. Method:{}", (Object)methodName);
        }
        return trace;
    }

    private void recordRootSpan(Trace trace, ThriftRequestProperty parentTraceInfo, Object target) {
        SpanRecorder recorder = trace.getSpanRecorder();
        recorder.recordServiceType(ThriftConstants.THRIFT_SERVER);
        recorder.recordApi((MethodDescriptor)this.thriftServerEntryMethodDescriptor);
        if (!trace.isRoot()) {
            this.recordParentInfo(recorder, parentTraceInfo);
        }
        TTransport transport = ((TProtocol)target).getTransport();
        this.recordConnection(recorder, transport);
    }

    private boolean checkSamplingFlag(ThriftRequestProperty parentTraceInfo) {
        if (parentTraceInfo == null) {
            return true;
        }
        Boolean samplingFlag = parentTraceInfo.shouldSample();
        if (this.isDebug) {
            this.logger.debug("SamplingFlag:{}", (Object)samplingFlag);
        }
        if (samplingFlag == null) {
            return true;
        }
        return samplingFlag;
    }

    private TraceId populateTraceIdThriftHeader(ThriftRequestProperty parentTraceInfo) {
        if (parentTraceInfo == null) {
            return null;
        }
        String transactionId = parentTraceInfo.getTraceId();
        long parentSpanId = parentTraceInfo.getParentSpanId(-1L);
        long spanId = parentTraceInfo.getSpanId(-1L);
        short flags = parentTraceInfo.getFlags((short)0);
        return this.traceContext.createTraceId(transactionId, parentSpanId, spanId, flags);
    }

    private void recordParentInfo(SpanRecorder recorder, ThriftRequestProperty parentTraceInfo) {
        if (parentTraceInfo == null) {
            return;
        }
        String parentApplicationName = parentTraceInfo.getParentApplicationName();
        short parentApplicationType = parentTraceInfo.getParentApplicationType(ServiceType.UNDEFINED.getCode());
        String acceptorHost = parentTraceInfo.getAcceptorHost();
        recorder.recordParentApplication(parentApplicationName, parentApplicationType);
        recorder.recordAcceptorHost(acceptorHost);
    }

    private void recordConnection(SpanRecorder recorder, TTransport transport) {
        String localIpPort = "Unknown";
        String remoteAddress = "Unknown";
        Socket socket = ((SocketFieldAccessor)transport)._$PINPOINT$_getSocket();
        if (socket != null) {
            localIpPort = ThriftUtils.getIpPort(socket.getLocalSocketAddress());
            remoteAddress = ThriftUtils.getIp(socket.getRemoteSocketAddress());
        }
        if (localIpPort != "Unknown") {
            recorder.recordEndPoint(localIpPort);
        }
        if (remoteAddress != "Unknown") {
            recorder.recordRemoteAddress(remoteAddress);
        }
    }
}

