/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans.interceptor;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.util.PathMatcher;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansConfig;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTarget;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTargetScope;
import com.navercorp.pinpoint.plugin.spring.beans.interceptor.Cache;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;

public class TargetBeanFilter {
    private final List<SpringBeansTarget> targets;
    private static Cache cache = new Cache();

    public static TargetBeanFilter of(ProfilerConfig profilerConfig) {
        SpringBeansConfig config = new SpringBeansConfig(profilerConfig);
        return new TargetBeanFilter(config.getTargets());
    }

    public TargetBeanFilter(Collection<SpringBeansTarget> targets) {
        this.targets = new ArrayList<SpringBeansTarget>(targets);
    }

    public void clear() {
        cache.clear();
    }

    public boolean isTarget(SpringBeansTargetScope scope, String beanName, BeanDefinition beanDefinition) {
        if (scope == null || beanName == null || beanDefinition == null) {
            return false;
        }
        String className = beanDefinition.getBeanClassName();
        if (className == null) {
            return false;
        }
        if (cache.contains(className)) {
            return false;
        }
        for (SpringBeansTarget target : this.targets) {
            List<String> annotations;
            List<PathMatcher> classPatterns;
            List<PathMatcher> namePatterns;
            if (target.getScope() != scope) continue;
            boolean condition = false;
            List<String> basePackages = target.getBasePackages();
            if (CollectionUtils.hasLength(basePackages)) {
                if (!this.isBasePackage(target, className)) continue;
                condition = true;
            }
            if (CollectionUtils.hasLength(namePatterns = target.getNamePatterns())) {
                if (!this.isBeanNameTarget(target, beanName)) continue;
                condition = true;
            }
            if (CollectionUtils.hasLength(classPatterns = target.getClassPatterns())) {
                if (!this.isClassNameTarget(target, className)) continue;
                condition = true;
            }
            if (CollectionUtils.hasLength(annotations = target.getAnnotations())) {
                if (!(beanDefinition instanceof AnnotatedBeanDefinition) || !this.isAnnotationTarget(target, (AnnotatedBeanDefinition)beanDefinition)) continue;
                condition = true;
            }
            if (!condition) continue;
            return true;
        }
        return false;
    }

    public boolean isTarget(SpringBeansTargetScope scope, String beanName, Class<?> clazz) {
        if (scope == null || beanName == null || clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (className == null) {
            return false;
        }
        if (cache.contains(className)) {
            return false;
        }
        for (SpringBeansTarget target : this.targets) {
            List<String> annotations;
            List<PathMatcher> classPatterns;
            List<PathMatcher> namePatterns;
            if (target.getScope() != scope) continue;
            boolean condition = false;
            List<String> basePackages = target.getBasePackages();
            if (CollectionUtils.hasLength(basePackages)) {
                if (!this.isBasePackage(target, className)) continue;
                condition = true;
            }
            if (CollectionUtils.hasLength(namePatterns = target.getNamePatterns())) {
                if (!this.isBeanNameTarget(target, beanName)) continue;
                condition = true;
            }
            if (CollectionUtils.hasLength(classPatterns = target.getClassPatterns())) {
                if (!this.isClassNameTarget(target, className)) continue;
                condition = true;
            }
            if (CollectionUtils.hasLength(annotations = target.getAnnotations())) {
                if (!this.isAnnotationTarget(target, clazz)) continue;
                condition = true;
            }
            if (!condition) continue;
            return true;
        }
        return false;
    }

    private boolean isBasePackage(SpringBeansTarget target, String className) {
        for (String basePackage : target.getBasePackages()) {
            if (!className.startsWith(basePackage)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeanNameTarget(SpringBeansTarget target, String beanName) {
        for (PathMatcher pathMatcher : target.getNamePatterns()) {
            if (!pathMatcher.isMatched(beanName)) continue;
            return true;
        }
        return false;
    }

    private boolean isClassNameTarget(SpringBeansTarget target, String className) {
        for (PathMatcher pathMatcher : target.getClassPatterns()) {
            if (!pathMatcher.isMatched(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotationTarget(SpringBeansTarget target, AnnotatedBeanDefinition annotatedBeanDefinition) {
        for (String annotationName : target.getAnnotations()) {
            if (annotatedBeanDefinition.getMetadata().hasAnnotation(annotationName)) {
                return true;
            }
            if (!annotatedBeanDefinition.getMetadata().hasMetaAnnotation(annotationName)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotationTarget(SpringBeansTarget target, Class<?> clazz) {
        for (Annotation a : clazz.getAnnotations()) {
            if (!target.getAnnotations().contains(a.annotationType().getName())) continue;
            return true;
        }
        for (Annotation a : clazz.getAnnotations()) {
            for (Annotation ac : a.annotationType().getAnnotations()) {
                if (!target.getAnnotations().contains(ac.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void addTransformed(String className) {
        cache.put(className);
    }
}

