/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo.interceptor;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.MongoDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.mongo.MongoConstants;
import com.navercorp.pinpoint.plugin.mongo.MongoUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MongoDriverConnectInterceptor3_7
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logBeforeInterceptor(target, args);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        boolean success;
        if (this.isDebug) {
            this.logAfterInterceptor(target, args, result, throwable);
        }
        if (success = InterceptorUtils.isSuccess((Throwable)throwable)) {
            String writeConcern;
            String readPreference;
            if (args == null) {
                return;
            }
            List<String> hostList = this.getHostList(args[0]);
            DatabaseInfo databaseInfo = this.createDatabaseInfo(hostList, readPreference = this.getReadPreference(args[0]), writeConcern = this.getWriteConcern(args[0]));
            if (databaseInfo == null) {
                databaseInfo = UnKnownDatabaseInfo.MONGO_INSTANCE;
            }
            if (result instanceof DatabaseInfoAccessor) {
                ((DatabaseInfoAccessor)result)._$PINPOINT$_setDatabaseInfo(databaseInfo);
            }
        }
    }

    private void logBeforeInterceptor(Object target, Object[] args) {
        this.logger.beforeInterceptor(target, args);
    }

    private void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        this.logger.afterInterceptor(target, args, result, throwable);
    }

    private DatabaseInfo createDatabaseInfo(List<String> hostList, String readPreference, String writeConcern) {
        MongoDatabaseInfo databaseInfo = new MongoDatabaseInfo(MongoConstants.MONGODB, MongoConstants.MONGO_EXECUTE_QUERY, null, null, hostList, null, null, readPreference, writeConcern);
        if (this.isDebug) {
            this.logger.debug("parse DatabaseInfo:{}", (Object)databaseInfo);
        }
        return databaseInfo;
    }

    private List<String> getHostList(Object arg) {
        if (!(arg instanceof MongoClientSettings)) {
            return Collections.emptyList();
        }
        MongoClientSettings mongoClientSettings = (MongoClientSettings)arg;
        List lists = mongoClientSettings.getClusterSettings().getHosts();
        ArrayList<String> hostList = new ArrayList<String>();
        for (ServerAddress sa : lists) {
            String hostAddress = HostAndPort.toHostAndPortString((String)sa.getHost(), (int)sa.getPort());
            hostList.add(hostAddress);
        }
        return hostList;
    }

    private String getReadPreference(Object arg) {
        if (!(arg instanceof MongoClientSettings)) {
            return null;
        }
        MongoClientSettings mongoClientSettings = (MongoClientSettings)arg;
        return mongoClientSettings.getReadPreference().getName();
    }

    private String getWriteConcern(Object arg) {
        if (!(arg instanceof MongoClientSettings)) {
            return null;
        }
        MongoClientSettings mongoClientSettings = (MongoClientSettings)arg;
        return MongoUtil.getWriteConcern0(mongoClientSettings.getWriteConcern());
    }
}

