/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cxf.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.cxf.CxfPluginConstants;
import org.apache.cxf.interceptor.LoggingMessage;

public abstract class CxfLoggingMessageMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    protected CxfLoggingMessageMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor);
    }

    protected void recordAttributes(SpanEventRecorder recorder, LoggingMessage loggingMessage) {
        StringBuilder payload;
        StringBuilder message;
        StringBuilder header;
        StringBuilder contentType;
        StringBuilder httpMethod;
        StringBuilder encoding;
        StringBuilder responseCode;
        StringBuilder address = loggingMessage.getAddress();
        if (address.length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_ADDRESS, address.toString());
        }
        if ((responseCode = loggingMessage.getResponseCode()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_RESPONSE_CODE, responseCode.toString());
        }
        if ((encoding = loggingMessage.getEncoding()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_ENCODING, encoding.toString());
        }
        if ((httpMethod = loggingMessage.getHttpMethod()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_HTTP_METHOD, httpMethod.toString());
        }
        if ((contentType = loggingMessage.getContentType()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_CONTENT_TYPE, contentType.toString());
        }
        if ((header = loggingMessage.getHeader()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_HEADERS, header.toString());
        }
        if ((message = loggingMessage.getMessage()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_MESSAGES, message.toString());
        }
        if ((payload = loggingMessage.getPayload()).length() > 0) {
            recorder.recordAttribute(CxfPluginConstants.CXF_PAYLOAD, payload.toString());
        }
    }
}

