/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerClassLambdaMetafactoryTransformer
implements ClassFileTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String InnerClassLambdaMetafactory = "java/lang/invoke/InnerClassLambdaMetafactory";
    private final Object lambdaFactoryClassAdaptor;
    private final Method transformMethod;

    public InnerClassLambdaMetafactoryTransformer() {
        try {
            ClassLoader agentClassLoader = this.getClass().getClassLoader();
            Class<?> lambdaAdaptor = agentClassLoader.loadClass("com.navercorp.pinpoint.profiler.instrument.lambda.LambdaFactoryClassAdaptor");
            Constructor<?> constructor = lambdaAdaptor.getConstructor(new Class[0]);
            this.lambdaFactoryClassAdaptor = constructor.newInstance(new Object[0]);
            this.transformMethod = lambdaAdaptor.getMethod("loadTransformedBytecode", byte[].class);
        }
        catch (Exception e) {
            throw new IllegalStateException("LambdaFactoryClassAdaptor initialize fail Caused by:" + e.getMessage(), e);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!InnerClassLambdaMetafactory.equals(className)) {
            return null;
        }
        try {
            this.logger.debug("transform InnerClassLambdaMetafactory");
            byte[] transformBytecode = (byte[])this.transformMethod.invoke(this.lambdaFactoryClassAdaptor, new Object[]{classfileBuffer});
            return transformBytecode;
        }
        catch (Exception e) {
            this.logger.warn("InnerClassLambdaMetafactory transform fail Caused by:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

