/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.client.async;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftConstants;
import com.navercorp.pinpoint.plugin.thrift.ThriftRequestProperty;
import com.navercorp.pinpoint.plugin.thrift.ThriftUtils;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketAddressFieldAccessor;
import java.net.SocketAddress;
import org.apache.thrift.async.TAsyncMethodCall;

public class TAsyncClientManagerCallInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final InterceptorScope scope;

    public TAsyncClientManagerCallInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!this.validate(target, args)) {
            return;
        }
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }
        try {
            ThriftRequestProperty parentTraceInfo = new ThriftRequestProperty();
            boolean shouldSample = trace.canSampled();
            if (!shouldSample) {
                if (this.isDebug) {
                    this.logger.debug("set Sampling flag=false");
                }
                parentTraceInfo.setShouldSample(shouldSample);
            } else {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                Object asyncMethodCallObj = args[0];
                this.injectAsyncContext(asyncMethodCallObj, recorder);
                String remoteAddress = this.getRemoteAddress(asyncMethodCallObj);
                TraceId nextId = trace.getTraceId().getNextTraceId();
                long nextSpanId = nextId.getSpanId();
                parentTraceInfo.setSpanId(nextSpanId);
                parentTraceInfo.setTraceId(nextId.getTransactionId());
                parentTraceInfo.setParentSpanId(nextId.getParentSpanId());
                parentTraceInfo.setFlags(nextId.getFlags());
                parentTraceInfo.setParentApplicationName(this.traceContext.getApplicationName());
                parentTraceInfo.setParentApplicationType(this.traceContext.getServerTypeCode());
                parentTraceInfo.setAcceptorHost(remoteAddress);
                recorder.recordServiceType(ThriftConstants.THRIFT_CLIENT);
                recorder.recordNextSpanId(nextSpanId);
                recorder.recordDestinationId(remoteAddress);
                String methodUri = ThriftUtils.getAsyncMethodCallName((TAsyncMethodCall)asyncMethodCallObj);
                String thriftUrl = remoteAddress + "/" + methodUri;
                recorder.recordAttribute(ThriftConstants.THRIFT_URL, thriftUrl);
            }
            InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
            currentTransaction.setAttachment((Object)parentTraceInfo);
        }
        catch (Throwable t) {
            this.logger.warn("BEFORE error. Caused:{}", (Object)t.getMessage(), (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        catch (Throwable t) {
            this.logger.warn("AFTER error. Caused:{}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (args.length != 1) {
            return false;
        }
        Object asyncMethodCallObj = args[0];
        if (asyncMethodCallObj == null) {
            if (this.isDebug) {
                this.logger.debug("Field accessor target object is null.");
            }
            return false;
        }
        if (!(asyncMethodCallObj instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    private void injectAsyncContext(Object asyncMethodCallObj, SpanEventRecorder recorder) {
        AsyncContext asyncContext = recorder.recordNextAsyncContext();
        ((AsyncContextAccessor)asyncMethodCallObj)._$PINPOINT$_setAsyncContext(asyncContext);
        if (this.isDebug) {
            this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
        }
    }

    private String getRemoteAddress(Object asyncMethodCallObj) {
        if (!(asyncMethodCallObj instanceof SocketAddressFieldAccessor)) {
            return "Unknown";
        }
        SocketAddress socketAddress = ((SocketAddressFieldAccessor)asyncMethodCallObj)._$PINPOINT$_getSocketAddress();
        return ThriftUtils.getHostPort(socketAddress);
    }
}

