/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.autolog;

import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class UpdateLockTimeJob
implements Runnable {
    private ILogger logger = LoggerFactory.getLogger("UpdateLockTimeJob");
    private String processId;
    private File lockFile;
    private String containerId;

    UpdateLockTimeJob(String processId, File lockFile, String containerId) {
        this.processId = processId;
        this.lockFile = lockFile;
        this.containerId = containerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.lockFile == null || !this.lockFile.exists() || this.processId == null || this.processId.length() <= 0) return;
        FilterOutputStream bos = null;
        bos = new BufferedOutputStream(new FileOutputStream(this.lockFile));
        if (this.containerId == null) {
            bos.write((this.processId + ":" + System.currentTimeMillis()).getBytes());
        } else {
            bos.write((this.containerId + ":" + this.processId + ":" + System.currentTimeMillis()).getBytes());
        }
        ((BufferedOutputStream)bos).flush();
        if (bos == null) return;
        try {
            bos.close();
            return;
        }
        catch (IOException e) {
            this.logger.debug("UpdateLockTimeJob close BufferedOutputStream found IOException {}", e.getMessage());
        }
        return;
        catch (FileNotFoundException e) {
            this.logger.debug("UpdateLockTimeJob found FileNotFoundException {}", e.getMessage());
            if (bos == null) return;
            try {
                bos.close();
                return;
            }
            catch (IOException e2) {
                this.logger.debug("UpdateLockTimeJob close BufferedOutputStream found IOException {}", e2.getMessage());
            }
            return;
        }
        catch (IOException e2) {
            this.logger.debug("UpdateLockTimeJob found IOException {}", e2.getMessage());
            if (bos == null) return;
            {
                catch (Throwable throwable) {
                    if (bos == null) throw throwable;
                    try {
                        bos.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        this.logger.debug("UpdateLockTimeJob close BufferedOutputStream found IOException {}", e3.getMessage());
                    }
                    throw throwable;
                }
            }
            try {
                bos.close();
                return;
            }
            catch (IOException e4) {
                this.logger.debug("UpdateLockTimeJob close BufferedOutputStream found IOException {}", e4.getMessage());
            }
            return;
        }
    }
}

