/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.tools.network;

import com.navercorp.pinpoint.tools.network.AbstractNetworkChecker;
import com.navercorp.pinpoint.tools.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;

public class TCPChecker
extends AbstractNetworkChecker {
    public TCPChecker(String testName, String hostName, int port) throws UnknownHostException {
        this(testName, new InetSocketAddress(hostName, port));
    }

    public TCPChecker(String testName, InetSocketAddress hostAddress) throws UnknownHostException {
        super(testName, hostAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean check(InetSocketAddress address) throws IOException {
        Socket socket = null;
        try {
            socket = this.createSocket(address);
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(socket);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean check(InetSocketAddress address, byte[] requestData, byte[] expectedResponseData) throws IOException {
        Socket socket = null;
        try {
            socket = this.createSocket(address);
            this.write(socket, requestData);
            byte[] responseData = this.read(socket, 100);
            boolean bl = Arrays.equals(expectedResponseData, responseData);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(socket);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createSocket(InetSocketAddress socketAddress) throws IOException {
        Socket socket = null;
        boolean success = false;
        try {
            socket = new Socket();
            socket.setSoTimeout(3000);
            socket.connect(socketAddress);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly(socket);
            }
        }
        return socket;
    }

    private void write(Socket socket, byte[] requestData) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(requestData);
        outputStream.flush();
    }

    private byte[] read(Socket socket, int readSize) throws IOException {
        byte[] buf = new byte[readSize];
        InputStream inputStream = socket.getInputStream();
        int read = inputStream.read(buf);
        if (read == -1) {
            return IOUtils.EMPTY_BYTES;
        }
        return Arrays.copyOf(buf, read);
    }
}

