/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.SqlModule;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;

public class StatementCreateInterceptor
implements AroundInterceptor {
    private static final Class<?> CONNECTION_CLASS = StatementCreateInterceptor.getConnectionClass();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;

    private static Class<?> getConnectionClass() {
        if (!SqlModule.isSqlModuleEnable()) {
            throw new IllegalStateException("java.sql.Connection not exist");
        }
        return SqlModule.getSqlConnection();
    }

    public StatementCreateInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    @Override
    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (InterceptorUtils.isThrowable(throwable)) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        if (CONNECTION_CLASS.isInstance(target)) {
            DatabaseInfo databaseInfo = this.getDatabaseInfo(target);
            if (result instanceof DatabaseInfoAccessor) {
                ((DatabaseInfoAccessor)result)._$PINPOINT$_setDatabaseInfo(databaseInfo);
            }
        }
    }

    private DatabaseInfo getDatabaseInfo(Object target) {
        DatabaseInfo databaseInfo = null;
        if (target instanceof DatabaseInfoAccessor) {
            databaseInfo = ((DatabaseInfoAccessor)target)._$PINPOINT$_getDatabaseInfo();
        }
        if (databaseInfo == null) {
            databaseInfo = UnKnownDatabaseInfo.INSTANCE;
        }
        return databaseInfo;
    }
}

