/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.compress;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.compress.Context;
import com.navercorp.pinpoint.profiler.context.compress.ContextV2;
import com.navercorp.pinpoint.profiler.context.compress.SpanEventSequenceComparator;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessor;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SpanPostProcessorV2
implements SpanPostProcessor<Context> {
    private static final byte V2 = TraceDataFormatVersion.V2.getVersion();
    private static final Comparator<SpanEvent> SEQUENCE_COMPARATOR = SpanEventSequenceComparator.INSTANCE;

    @Override
    public Context newContext(Span span, TSpan tSpan) {
        tSpan.setVersion(V2);
        List<SpanEvent> spanEventList = span.getSpanEventList();
        Collections.sort(spanEventList, SEQUENCE_COMPARATOR);
        long keyTime = this.getKeyTime(spanEventList);
        return new ContextV2(keyTime);
    }

    @Override
    public Context newContext(SpanChunk spanChunk, TSpanChunk tSpanChunk) {
        tSpanChunk.setVersion(V2);
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        Collections.sort(spanEventList, SEQUENCE_COMPARATOR);
        long keyTime = this.getKeyTime(spanEventList);
        tSpanChunk.setKeyTime(keyTime);
        return new ContextV2(keyTime);
    }

    @Override
    public void postProcess(Context context, SpanEvent spanEvent, TSpanEvent tSpanEvent) {
        ContextV2 context2 = (ContextV2)context;
        long startTime = spanEvent.getStartTime();
        long keyTime = context.keyTime();
        long startElapsedTime = startTime - keyTime;
        tSpanEvent.setStartElapsed((int)startElapsedTime);
        context2.setKeyTime(startTime);
        if (context2.getIndex() == 0) {
            int depth = spanEvent.getDepth();
            context2.setPrevDepth(depth);
            tSpanEvent.setDepth(depth);
        } else {
            int prevDepth;
            int currentDepth = spanEvent.getDepth();
            if (currentDepth == (prevDepth = context2.getPrevDepth())) {
                tSpanEvent.setDepth(0);
            } else {
                tSpanEvent.setDepth(currentDepth);
            }
            context2.setPrevDepth(currentDepth);
        }
    }

    private long getKeyTime(List<SpanEvent> spanEventList) {
        if (CollectionUtils.isEmpty(spanEventList)) {
            throw new IllegalArgumentException("spanEventList is empty.");
        }
        SpanEvent first = spanEventList.get(0);
        if (first == null) {
            throw new IllegalStateException("first SpanEvent is null");
        }
        return first.getStartTime();
    }
}

