/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncTraceIdAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncTraceId;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.ServiceType;

public abstract class SpanAsyncEventSimpleAroundInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected static final String ASYNC_TRACE_SCOPE = "##ASYNC_TRACE_SCOPE";
    protected final MethodDescriptor methodDescriptor;
    protected final TraceContext traceContext;
    final MethodDescriptor asyncMethodDescriptor = new AsyncMethodDescriptor();

    public SpanAsyncEventSimpleAroundInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        traceContext.cacheApi(this.asyncMethodDescriptor);
    }

    @Override
    public void before(Object target, Object[] args) {
        block5: {
            AsyncTraceId asyncTraceId;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((asyncTraceId = this.getAsyncTraceId(target)) == null) {
                this.logger.debug("Not found asynchronous invocation metadata");
                return;
            }
            Trace trace = this.traceContext.currentRawTraceObject();
            if (trace == null ? (trace = this.createAsyncTrace(asyncTraceId)) == null : !trace.canSampled()) {
                return;
            }
            this.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.doInBeforeTrace(recorder, asyncTraceId, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, AsyncTraceId var2, Object var3, Object[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        AsyncTraceId asyncTraceId;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((asyncTraceId = this.getAsyncTraceId(target)) == null) {
            this.logger.debug("Not found asynchronous invocation metadata");
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        if (!this.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (this.isAsyncTraceDestination(trace)) {
                this.deleteAsyncTrace(trace);
            }
        }
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5);

    protected AsyncTraceId getAsyncTraceId(Object target) {
        if (target instanceof AsyncTraceIdAccessor) {
            return ((AsyncTraceIdAccessor)target)._$PINPOINT$_getAsyncTraceId();
        }
        return null;
    }

    private Trace createAsyncTrace(AsyncTraceId asyncTraceId) {
        TraceScope oldScope;
        Trace trace = this.traceContext.continueAsyncTraceObject(asyncTraceId, asyncTraceId.getAsyncId(), asyncTraceId.getSpanStartTime());
        if (trace == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to continue async trace. 'result is null'");
            }
            return null;
        }
        if (this.isDebug) {
            this.logger.debug("createAsyncTrace() trace={}, asyncTraceId={}", (Object)trace, (Object)asyncTraceId);
        }
        if ((oldScope = trace.addScope(ASYNC_TRACE_SCOPE)) != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Duplicated async trace scope={}.", (Object)oldScope.getName());
            }
            this.deleteAsyncTrace(trace);
            return null;
        }
        SpanEventRecorder recorder = trace.currentSpanEventRecorder();
        recorder.recordServiceType(ServiceType.ASYNC);
        recorder.recordApi(this.asyncMethodDescriptor);
        return trace;
    }

    private void deleteAsyncTrace(Trace trace) {
        if (this.isDebug) {
            this.logger.debug("Delete async trace {}.", (Object)trace);
        }
        this.traceContext.removeTraceObject();
        trace.close();
    }

    private void entryAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            scope.tryEnter();
        }
    }

    private boolean leaveAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isAsyncTraceDestination(Trace trace) {
        if (!trace.isAsync()) {
            return false;
        }
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        return scope != null && !scope.isActive();
    }

    public static class AsyncMethodDescriptor
    implements MethodDescriptor {
        private int apiId = 0;

        @Override
        public String getMethodName() {
            return "";
        }

        @Override
        public String getClassName() {
            return "";
        }

        @Override
        public String[] getParameterTypes() {
            return null;
        }

        @Override
        public String[] getParameterVariableName() {
            return null;
        }

        @Override
        public String getParameterDescriptor() {
            return "";
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public String getFullName() {
            return AsyncMethodDescriptor.class.getName();
        }

        @Override
        public void setApiId(int apiId) {
            this.apiId = apiId;
        }

        @Override
        public int getApiId() {
            return this.apiId;
        }

        @Override
        public String getApiDescriptor() {
            return "Asynchronous Invocation";
        }

        @Override
        public int getType() {
            return 200;
        }
    }
}

