/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaData;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClientReconnectEventListener;
import com.navercorp.pinpoint.test.MethodDescriptionUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class TestTcpDataSender
implements EnhancedDataSender<Object> {
    private final List<Object> datas = Collections.synchronizedList(new ArrayList());
    private final BiMap<Integer, String> apiIdMap = this.newSynchronizedBiMap();
    private final BiMap<Integer, String> sqlIdMap = this.newSynchronizedBiMap();
    private final BiMap<Integer, String> stringIdMap = this.newSynchronizedBiMap();
    private static final Comparator<Map.Entry<Integer, String>> COMPARATOR = new Comparator<Map.Entry<Integer, String>>(){

        @Override
        public int compare(Map.Entry<Integer, String> o1, Map.Entry<Integer, String> o2) {
            return o1.getKey() > o2.getKey() ? 1 : (o1.getKey() < o2.getKey() ? -1 : 0);
        }
    };

    private <K, V> BiMap<K, V> newSynchronizedBiMap() {
        HashBiMap hashBiMap = HashBiMap.create();
        return Maps.synchronizedBiMap((BiMap)hashBiMap);
    }

    public boolean send(Object data) {
        this.addData(data);
        return false;
    }

    private void addData(Object data) {
        if (data instanceof ApiMetaData) {
            ApiMetaData md = (ApiMetaData)data;
            String javaMethodDescriptor = this.toJavaMethodDescriptor(md);
            this.apiIdMap.put((Object)md.getApiId(), (Object)javaMethodDescriptor);
        } else if (data instanceof SqlMetaData) {
            SqlMetaData md = (SqlMetaData)data;
            int id = md.getSqlId();
            String sql = md.getSql();
            this.sqlIdMap.put((Object)id, (Object)sql);
        } else if (data instanceof StringMetaData) {
            StringMetaData md = (StringMetaData)data;
            int id = md.getStringId();
            String string = md.getStringValue();
            this.stringIdMap.put((Object)id, (Object)string);
        }
        this.datas.add(data);
    }

    private String toJavaMethodDescriptor(ApiMetaData apiMetaData) {
        String apiInfo = apiMetaData.getApiInfo();
        if (apiInfo.indexOf(40) == -1) {
            return apiInfo;
        }
        return MethodDescriptionUtils.toJavaMethodDescriptor(apiInfo);
    }

    public void stop() {
    }

    public boolean request(Object data) {
        this.addData(data);
        return true;
    }

    public boolean request(Object data, int retry) {
        this.addData(data);
        return true;
    }

    public boolean request(Object data, FutureListener<ResponseMessage> listener) {
        this.addData(data);
        return true;
    }

    public boolean addReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        return false;
    }

    public boolean removeReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        return false;
    }

    public String getApiDescription(int id) {
        return (String)this.apiIdMap.get((Object)id);
    }

    public int getApiId(String description) {
        BiMap apiDescriptionMap = this.apiIdMap.inverse();
        Integer id = (Integer)apiDescriptionMap.get((Object)description);
        if (id == null) {
            throw new NoSuchElementException(description);
        }
        return id;
    }

    public String getString(int id) {
        return (String)this.stringIdMap.get((Object)id);
    }

    public int getStringId(String string) {
        BiMap stringMap = this.stringIdMap.inverse();
        Integer id = (Integer)stringMap.get((Object)string);
        if (id == null) {
            throw new NoSuchElementException(string);
        }
        return id;
    }

    public String getSql(int id) {
        return (String)this.sqlIdMap.get((Object)id);
    }

    public int getSqlId(String sql) {
        BiMap sqlMap = this.sqlIdMap.inverse();
        Integer id = (Integer)sqlMap.get((Object)sql);
        if (id == null) {
            throw new NoSuchElementException(sql);
        }
        return id;
    }

    public List<Object> getDatas() {
        return this.datas;
    }

    public void clear() {
        this.datas.clear();
    }

    public void printDatas(PrintStream out) {
        out.println("API(" + this.apiIdMap.size() + "):");
        this.printApis(out);
        out.println("SQL(" + this.sqlIdMap.size() + "):");
        this.printSqls(out);
        out.println("STRING(" + this.stringIdMap.size() + "):");
        this.printStrings(out);
    }

    public void printApis(PrintStream out) {
        ArrayList<Map.Entry<Integer, String>> apis = new ArrayList<Map.Entry<Integer, String>>(this.apiIdMap.entrySet());
        this.printEntries(out, apis);
    }

    public void printStrings(PrintStream out) {
        ArrayList<Map.Entry<Integer, String>> strings = new ArrayList<Map.Entry<Integer, String>>(this.stringIdMap.entrySet());
        this.printEntries(out, strings);
    }

    public void printSqls(PrintStream out) {
        ArrayList<Map.Entry<Integer, String>> sqls = new ArrayList<Map.Entry<Integer, String>>(this.sqlIdMap.entrySet());
        this.printEntries(out, sqls);
    }

    private void printEntries(PrintStream out, List<Map.Entry<Integer, String>> entries) {
        Collections.sort(entries, COMPARATOR);
        for (Map.Entry<Integer, String> e : entries) {
            out.println(e.getKey() + ": " + e.getValue());
        }
    }
}

