/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.util;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientFactoryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientFactoryUtils.class);

    public static PinpointClientProvider newPinpointClientProvider(String host, int port, PinpointClientFactory clientFactory) {
        return new DnsPinpointClientProvider(host, port, clientFactory);
    }

    public static PinpointClient createPinpointClient(String host, int port, PinpointClientFactory clientFactory) {
        PinpointClient pinpointClient = null;
        for (int i = 0; i < 3; ++i) {
            try {
                pinpointClient = clientFactory.connect(host, port);
                LOGGER.info("tcp connect success. remote:{}/{}", (Object)host, (Object)port);
                return pinpointClient;
            }
            catch (PinpointSocketException e) {
                LOGGER.warn("tcp connect fail. remote:{}/{} try reconnect, retryCount:{}", new Object[]{host, port, i});
                continue;
            }
        }
        LOGGER.warn("change background tcp connect mode remote:{}/{} ", (Object)host, (Object)port);
        pinpointClient = clientFactory.scheduledConnect(host, port);
        return pinpointClient;
    }

    @Deprecated
    public static PinpointClientProvider newPinpointClientProvider(InetSocketAddress inetSocketAddress, PinpointClientFactory clientFactory) {
        return new StaticPinpointClientProvider(inetSocketAddress, clientFactory);
    }

    @Deprecated
    public static PinpointClient createPinpointClient(InetSocketAddress connectAddress, PinpointClientFactory clientFactory) {
        PinpointClient pinpointClient = null;
        for (int i = 0; i < 3; ++i) {
            try {
                pinpointClient = clientFactory.connect(connectAddress);
                LOGGER.info("tcp connect success. remote:{}", (Object)connectAddress);
                return pinpointClient;
            }
            catch (PinpointSocketException e) {
                LOGGER.warn("tcp connect fail. remote:{} try reconnect, retryCount:{}", (Object)connectAddress, (Object)i);
                continue;
            }
        }
        LOGGER.warn("change background tcp connect mode remote:{} ", (Object)connectAddress);
        pinpointClient = clientFactory.scheduledConnect(connectAddress);
        return pinpointClient;
    }

    @Deprecated
    private static class StaticPinpointClientProvider
    implements PinpointClientProvider {
        private final InetSocketAddress inetSocketAddress;
        private final PinpointClientFactory clientFactory;

        public StaticPinpointClientProvider(InetSocketAddress inetSocketAddress, PinpointClientFactory clientFactory) {
            this.inetSocketAddress = (InetSocketAddress)Assert.requireNonNull((Object)inetSocketAddress, (String)"host must not be null");
            this.clientFactory = (PinpointClientFactory)Assert.requireNonNull((Object)clientFactory, (String)"clientFactory must not be null");
        }

        @Override
        public PinpointClient get() {
            return ClientFactoryUtils.createPinpointClient(this.inetSocketAddress, this.clientFactory);
        }
    }

    private static class DnsPinpointClientProvider
    implements PinpointClientProvider {
        private final PinpointClientFactory clientFactory;
        private final String host;
        private final int port;

        public DnsPinpointClientProvider(String host, int port, PinpointClientFactory clientFactory) {
            this.host = (String)Assert.requireNonNull((Object)host, (String)"host must not be null");
            this.port = port;
            this.clientFactory = (PinpointClientFactory)Assert.requireNonNull((Object)clientFactory, (String)"clientFactory must not be null");
        }

        @Override
        public PinpointClient get() {
            return ClientFactoryUtils.createPinpointClient(this.host, this.port, this.clientFactory);
        }
    }

    public static interface PinpointClientProvider {
        public PinpointClient get();
    }
}

