/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.BootstrapPackage;
import com.navercorp.pinpoint.profiler.instrument.scanner.JarFileRepository;
import java.io.InputStream;
import java.util.List;

public class BootstrapCore {
    private final BootstrapPackage bootstrapPackage;
    private final JarFileRepository bootstrapRepository;

    public BootstrapCore(List<String> bootstrapJarPaths) {
        Assert.requireNonNull(bootstrapJarPaths, (String)"bootstrapJarPaths must not be null");
        this.bootstrapRepository = new JarFileRepository(bootstrapJarPaths);
        this.bootstrapPackage = new BootstrapPackage();
    }

    public boolean isBootstrapPackage(String className) {
        return this.bootstrapPackage.isBootstrapPackage(className);
    }

    public boolean isBootstrapPackageByInternalName(String internalClassName) {
        return this.bootstrapPackage.isBootstrapPackageByInternalName(internalClassName);
    }

    public InputStream openStream(String internalClassName) {
        return this.bootstrapRepository.openStream(internalClassName);
    }
}

