/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientConstants;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;

public class ConsumerHandleDeliveryInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private static final String ASYNC_TRACE_SCOPE = "##ASYNC_TRACE_SCOPE";
    private final MethodDescriptor methodDescriptor;

    public ConsumerHandleDeliveryInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        this.methodDescriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        block6: {
            if (!this.validate(target, args)) {
                return;
            }
            AsyncContext asyncContext = AsyncContextAccessorUtils.getAsyncContext((Object)args[1]);
            if (asyncContext == null) {
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            this.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(RabbitMQClientConstants.RABBITMQ_CLIENT_INTERNAL);
                recorder.recordApi(this.methodDescriptor);
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("BEFORE error.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (!this.validate(target, args)) {
            return;
        }
        AsyncContext asyncContext = AsyncContextAccessorUtils.getAsyncContext((Object)args[1]);
        if (asyncContext == null) {
            return;
        }
        Trace trace = asyncContext.currentAsyncTraceObject();
        if (trace == null) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncContext(trace, asyncContext);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error.", t);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (this.isAsyncTraceDestination(trace)) {
                this.deleteAsyncContext(trace, asyncContext);
            }
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (!(target instanceof Consumer)) {
            return false;
        }
        if (args == null || args.length < 2) {
            return false;
        }
        if (!(args[1] instanceof Envelope)) {
            return false;
        }
        if (!(args[1] instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[1] object. Need accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    private Trace getAsyncTrace(AsyncContext asyncContext) {
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to continue async trace. 'result is null'");
            }
            return null;
        }
        if (this.isDebug) {
            this.logger.debug("getAsyncTrace() trace {}, asyncContext={}", (Object)trace, (Object)asyncContext);
        }
        return trace;
    }

    private void deleteAsyncContext(Trace trace, AsyncContext asyncContext) {
        if (this.isDebug) {
            this.logger.debug("Delete async trace {}.", (Object)trace);
        }
        trace.close();
        asyncContext.close();
    }

    private void entryAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            scope.tryEnter();
        }
    }

    private boolean leaveAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isAsyncTraceDestination(Trace trace) {
        if (!trace.isAsync()) {
            return false;
        }
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        return scope != null && !scope.isActive();
    }
}

