/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.classloader;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matchers;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.instrument.ASMEngine;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.instrument.classloading.DebugTransformerClassInjector;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerLoader;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformerGuardDelegate;
import com.navercorp.pinpoint.profiler.plugin.PluginInstrumentContext;
import com.navercorp.pinpoint.test.classloader.DefaultTranslator;
import com.navercorp.pinpoint.test.classloader.TestClassList;
import com.navercorp.pinpoint.test.classloader.TransformClassLoader;
import com.navercorp.pinpoint.test.classloader.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestClassLoader
extends TransformClassLoader {
    private final Logger logger = Logger.getLogger(TestClassLoader.class.getName());
    private final DefaultApplicationContext applicationContext;
    private Translator instrumentTranslator;
    private final List<String> delegateClass;
    private final ClassFileTransformerLoader classFileTransformerLoader;
    private final InstrumentContext instrumentContext;

    public TestClassLoader(DefaultApplicationContext applicationContext) {
        Assert.requireNonNull((Object)applicationContext, (String)"applicationContext must not be null");
        this.applicationContext = applicationContext;
        this.classFileTransformerLoader = new ClassFileTransformerLoader(applicationContext.getProfilerConfig(), applicationContext.getDynamicTransformTrigger());
        DebugTransformerClassInjector classInjector = new DebugTransformerClassInjector();
        this.instrumentContext = new PluginInstrumentContext(applicationContext.getProfilerConfig(), applicationContext.getInstrumentEngine(), applicationContext.getDynamicTransformTrigger(), (ClassInjector)classInjector, this.classFileTransformerLoader);
        this.delegateClass = new ArrayList<String>();
    }

    public void addDelegateClass(String className) {
        if (className == null) {
            throw new NullPointerException("className must not be null");
        }
        this.delegateClass.add(className);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("findClass className:{}" + name);
        }
        return super.findClass(name);
    }

    public void initialize() {
        this.addDefaultDelegateLoadingOf();
        this.addCustomDelegateLoadingOf();
        this.addTranslator();
    }

    private void addCustomDelegateLoadingOf() {
        for (String className : this.delegateClass) {
            this.delegateLoadingOf(className);
        }
    }

    public ProfilerConfig getProfilerConfig() {
        return this.applicationContext.getProfilerConfig();
    }

    public void addTransformer(String targetClassName, TransformCallback transformer) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("addTransformer targetClassName:{}" + targetClassName + " callback:{}" + transformer);
        }
        Matcher matcher = Matchers.newClassNameMatcher((String)targetClassName);
        MatchableClassFileTransformerGuardDelegate guard = new MatchableClassFileTransformerGuardDelegate(this.applicationContext.getProfilerConfig(), this.instrumentContext, matcher, transformer);
        this.instrumentTranslator.addTransformer((MatchableClassFileTransformer)guard);
    }

    private void addDefaultDelegateLoadingOf() {
        TestClassList testClassList = new TestClassList();
        for (String className : testClassList.getTestClassList()) {
            this.delegateLoadingOf(className);
        }
    }

    @Override
    protected Class<?> loadClassByDelegation(String name) throws ClassNotFoundException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("loadClassByDelegation className:{}" + name);
        }
        return super.loadClassByDelegation(name);
    }

    public void addTranslator() {
        this.instrumentTranslator = this.newTranslator();
        this.addTranslator(this.instrumentTranslator);
    }

    private Translator newTranslator() {
        InstrumentEngine instrumentEngine = this.applicationContext.getInstrumentEngine();
        if (instrumentEngine instanceof ASMEngine) {
            this.logger.info("ASM BCI engine");
            return new DefaultTranslator(this, this.applicationContext.getClassFileTransformer());
        }
        this.logger.info("Unknown BCI engine");
        return new DefaultTranslator(this, this.applicationContext.getClassFileTransformer());
    }
}

