/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtils {
    private static final ThreadLocal<DateFormat> CACHE = new ThreadLocal<DateFormat>(){
        private final String name = DateUtils.class.getName();

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.FORMAT);
        }
    };
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss SSS";

    private DateUtils() {
    }

    public static String longToDateStr(long date) {
        DateFormat dateFormat = CACHE.get();
        return dateFormat.format(date);
    }

    public static String longToDateStr(long date, String fmt) {
        String pattern = fmt == null ? FORMAT : fmt;
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(date));
    }

    public static long timestampToMidNight(long timestamp) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(timestamp));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }
}

