/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hikaricp;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitor;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.hikaricp.HikariCpConstants;
import java.lang.reflect.Method;

public class HikariCpDataSourceMonitor
implements DataSourceMonitor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final String jdbcUrl;
    private final Object object;
    private final Method getActiveConnectionsMethod;
    private final Method getTotalConnectionsMethod;
    private volatile boolean closed = false;

    public HikariCpDataSourceMonitor(Object object, String jdbcUrl) {
        this.object = object;
        this.jdbcUrl = jdbcUrl;
        try {
            this.getActiveConnectionsMethod = this.getActiveConnectionsMethod(object);
            this.getTotalConnectionsMethod = this.getTotalConnectionsMethod(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private Method getActiveConnectionsMethod(Object object) throws NoSuchMethodException {
        Method getActiveConnectionsMethod = object.getClass().getMethod("getActiveConnections", new Class[0]);
        if (getActiveConnectionsMethod == null) {
            throw new IllegalArgumentException("object must has getActiveConnections method");
        }
        Class<?> returnType = getActiveConnectionsMethod.getReturnType();
        if (Integer.TYPE != returnType) {
            throw new IllegalArgumentException("invalid return type. expected:int, actual:" + returnType);
        }
        return getActiveConnectionsMethod;
    }

    private Method getTotalConnectionsMethod(Object object) throws NoSuchMethodException {
        Method getTotalConnections = object.getClass().getMethod("getTotalConnections", new Class[0]);
        if (getTotalConnections == null) {
            throw new IllegalArgumentException("object must has getTotalConnections method");
        }
        Class<?> returnType = getTotalConnections.getReturnType();
        if (Integer.TYPE != returnType) {
            throw new IllegalArgumentException("invalid return type. expected:int, actual:" + returnType);
        }
        return getTotalConnections;
    }

    public ServiceType getServiceType() {
        return HikariCpConstants.SERVICE_TYPE;
    }

    public String getUrl() {
        return this.jdbcUrl;
    }

    public int getActiveConnectionSize() {
        try {
            Object result = this.getActiveConnectionsMethod.invoke(this.object, new Object[0]);
            return (Integer)result;
        }
        catch (Exception e) {
            this.logger.info("failed while executing getActiveConnectionSize()");
            return -1;
        }
    }

    public int getMaxConnectionSize() {
        try {
            Object result = this.getTotalConnectionsMethod.invoke(this.object, new Object[0]);
            return (Integer)result;
        }
        catch (Exception e) {
            this.logger.info("failed while executing getActiveConnectionSize()");
            return -1;
        }
    }

    public boolean isDisabled() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }
}

