/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.io.util;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.util.BodyFactory;
import com.navercorp.pinpoint.io.util.DefaultTypeLocator;
import com.navercorp.pinpoint.io.util.HeaderFactory;
import com.navercorp.pinpoint.io.util.HeaderFactoryV1;
import com.navercorp.pinpoint.io.util.TypeLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeLocatorBuilder<T> {
    private final Map<Integer, BodyFactory<T>> bodyFactoryMap = new HashMap<Integer, BodyFactory<T>>();
    private final Map<Class<?>, Header> bodyClassToHeaderMap = new LinkedHashMap();
    private final Map<Integer, Header> headerMap = new HashMap<Integer, Header>();
    private final HeaderFactory headerFactory;

    public TypeLocatorBuilder() {
        this(new HeaderFactoryV1());
    }

    public TypeLocatorBuilder(HeaderFactory headerFactory) {
        this.headerFactory = (HeaderFactory)Assert.requireNonNull((Object)headerFactory, (String)"headerFactory must not be null");
    }

    public void addBodyFactory(short type, BodyFactory<T> bodyFactory) {
        Class<?> bodyClass;
        Header oldBodyClass;
        if (bodyFactory == null) {
            throw new NullPointerException("bodyFactory must not be null");
        }
        BodyFactory<T> old = this.bodyFactoryMap.put(Integer.valueOf(type), bodyFactory);
        if (old != null) {
            throw new IllegalStateException("duplicated type:" + type);
        }
        Header header = this.headerFactory.newHeader(type);
        Header oldTypeHeader = this.headerMap.put(Integer.valueOf(type), header);
        if (oldTypeHeader != null) {
            throw new IllegalStateException("duplicated type:" + type);
        }
        T object = bodyFactory.getObject();
        if (object != null && (oldBodyClass = this.bodyClassToHeaderMap.put(bodyClass = object.getClass(), header)) != null) {
            throw new IllegalStateException("duplicated type:" + type);
        }
    }

    public TypeLocator<T> build() {
        IntHashMap copyBodyFactoryMap = IntHashMapUtils.copy(this.bodyFactoryMap);
        IdentityHashMap copyBodyClassToHeaderMap = new IdentityHashMap(this.bodyClassToHeaderMap);
        IntHashMap copyHeaderMap = IntHashMapUtils.copy(this.headerMap);
        List<DefaultTypeLocator.Entry<Class<?>, Header>> bodyClassToHeaderList = this.toList(this.bodyClassToHeaderMap);
        DefaultTypeLocator typeLocator = new DefaultTypeLocator(copyBodyFactoryMap, copyBodyClassToHeaderMap, (IntHashMap<Header>)copyHeaderMap, bodyClassToHeaderList);
        return typeLocator;
    }

    private List<DefaultTypeLocator.Entry<Class<?>, Header>> toList(Map<Class<?>, Header> bodyClassToHeaderMap) {
        ArrayList bodyClassToHeaderList = new ArrayList(bodyClassToHeaderMap.size());
        for (Map.Entry<Class<?>, Header> mapEntry : bodyClassToHeaderMap.entrySet()) {
            DefaultTypeLocator.Entry entry = new DefaultTypeLocator.Entry(mapEntry.getKey(), mapEntry.getValue());
            bodyClassToHeaderList.add(entry);
        }
        return bodyClassToHeaderList;
    }
}

