/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift;

import java.util.EnumSet;
import java.util.Set;

public enum ThriftHeader {
    THRIFT_TRACE_ID(11, Short.MIN_VALUE),
    THRIFT_SPAN_ID(10, -32767),
    THRIFT_PARENT_SPAN_ID(10, -32766),
    THRFIT_SAMPLED(2, -32765),
    THRIFT_FLAGS(6, -32764),
    THRIFT_PARENT_APPLICATION_NAME(11, -32763),
    THRIFT_PARENT_APPLICATION_TYPE(6, -32762),
    THRIFT_HOST(11, -32761);

    private final short id;
    private final byte type;
    private static final Set<ThriftHeader> HEADERS;

    private ThriftHeader(byte type, short id) {
        this.type = type;
        this.id = id;
    }

    public short getId() {
        return this.id;
    }

    public byte getType() {
        return this.type;
    }

    public static ThriftHeader findThriftHeaderKeyById(short id) {
        for (ThriftHeader headerKey : HEADERS) {
            if (headerKey.id != id) continue;
            return headerKey;
        }
        return null;
    }

    static {
        HEADERS = EnumSet.allOf(ThriftHeader.class);
    }
}

