/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.io.header.ByteArrayHeaderWriter;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;
import com.navercorp.pinpoint.io.request.FlinkRequest;
import com.navercorp.pinpoint.io.util.TypeLocator;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class FlinkHeaderTBaseSerializer {
    private final ResettableByteArrayOutputStream baos;
    private final TProtocol protocol;
    private final TypeLocator<TBase<?, ?>> locator;

    public FlinkHeaderTBaseSerializer(ResettableByteArrayOutputStream bos, TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this.baos = (ResettableByteArrayOutputStream)Assert.requireNonNull((Object)bos, (String)"ResettableByteArrayOutputStream must not be null.");
        this.locator = (TypeLocator)Assert.requireNonNull(locator, (String)"locator must not be null.");
        Assert.requireNonNull((Object)protocolFactory, (String)"TProtocolFactory must not be null.");
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)bos);
        this.protocol = protocolFactory.getProtocol((TTransport)transport);
    }

    public byte[] serialize(FlinkRequest flinkRequest) throws TException {
        this.baos.reset();
        this.writeHeader(flinkRequest);
        flinkRequest.getData().write(this.protocol);
        return this.baos.toByteArray();
    }

    private void writeHeader(FlinkRequest flinkRequest) {
        try {
            Header header = this.locator.headerLookup(flinkRequest.getData());
            ByteArrayHeaderWriter headerWriter = new ByteArrayHeaderWriter(header, flinkRequest.getHeaderEntity());
            byte[] headerBytes = headerWriter.writeHeader();
            this.baos.write(headerBytes);
        }
        catch (Exception e) {
            throw new InvalidHeaderException("can not write header.", e);
        }
    }
}

