/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutorListener;
import com.navercorp.pinpoint.profiler.sender.UnsafeArrayCollection;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueueingExecutor<T>
implements Runnable {
    private final Logger logger;
    private final boolean isWarn;
    private final LinkedBlockingQueue<T> queue;
    private final AtomicBoolean isRun = new AtomicBoolean(true);
    private final Thread executeThread;
    private final String executorName;
    private final int maxDrainSize;
    private final Collection<T> drain;
    private final AsyncQueueingExecutorListener<T> listener;

    public AsyncQueueingExecutor(int queueSize, String executorName, AsyncQueueingExecutorListener<T> listener) {
        Assert.requireNonNull((Object)executorName, (String)"executorName must not be null");
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "@" + executorName));
        this.isWarn = this.logger.isWarnEnabled();
        this.maxDrainSize = 10;
        this.drain = new UnsafeArrayCollection<T>(this.maxDrainSize);
        this.queue = new LinkedBlockingQueue(queueSize);
        this.executeThread = this.createExecuteThread(executorName);
        this.executorName = this.executeThread.getName();
        this.listener = (AsyncQueueingExecutorListener)Assert.requireNonNull(listener, (String)"listener must not be null");
    }

    private Thread createExecuteThread(String executorName) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory(executorName, true);
        Thread thread = threadFactory.newThread(this);
        thread.start();
        return thread;
    }

    @Override
    public void run() {
        this.logger.info("{} started.", (Object)this.executorName);
        this.doExecute();
    }

    private void doExecute() {
        while (this.isRun()) {
            try {
                Collection<T> dtoList = this.getDrainQueue();
                int drainSize = this.takeN(dtoList, this.maxDrainSize);
                if (drainSize > 0) {
                    this.doExecute((T)dtoList);
                    continue;
                }
                while (this.isRun()) {
                    T dto = this.takeOne();
                    if (dto == null) continue;
                    this.doExecute(dto);
                }
            }
            catch (Throwable th) {
                this.logger.warn("{} doExecute(). Unexpected Error. Cause:{}", new Object[]{this.executorName, th.getMessage(), th});
            }
        }
        this.flushQueue();
    }

    private void flushQueue() {
        Collection<T> dtoList;
        int drainSize;
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug("Loop is stop.");
        }
        while ((drainSize = this.takeN(dtoList = this.getDrainQueue(), this.maxDrainSize)) != 0) {
            if (debugEnabled) {
                this.logger.debug("flushData size {}", (Object)drainSize);
            }
            this.doExecute((T)dtoList);
        }
    }

    private T takeOne() {
        try {
            return this.queue.poll(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private int takeN(Collection<T> drain, int maxDrainSize) {
        return this.queue.drainTo(drain, maxDrainSize);
    }

    public boolean execute(T data) {
        if (data == null) {
            if (this.isWarn) {
                this.logger.warn("execute(). data is null");
            }
            return false;
        }
        if (!this.isRun.get()) {
            if (this.isWarn) {
                this.logger.warn("{} is shutdown. discard data:{}", (Object)this.executorName, data);
            }
            return false;
        }
        boolean offer = this.queue.offer(data);
        if (!offer && this.isWarn) {
            this.logger.warn("{} Drop data. queue is full. size:{}", (Object)this.executorName, (Object)this.queue.size());
        }
        return offer;
    }

    private void doExecute(Collection<T> dtoList) {
        this.listener.execute(dtoList);
    }

    private void doExecute(T dto) {
        this.listener.execute(dto);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isRun() {
        return this.isRun.get();
    }

    public void stop() {
        this.isRun.set(false);
        if (!this.isEmpty()) {
            this.logger.info("Wait 5 seconds. Flushing queued data.");
        }
        this.executeThread.interrupt();
        try {
            this.executeThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("{} stopped incompletely.", (Object)this.executorName);
        }
        this.logger.info("{} stopped.", (Object)this.executorName);
    }

    Collection<T> getDrainQueue() {
        this.drain.clear();
        return this.drain;
    }
}

