/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.buffer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetric;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferMetricProvider
implements Provider<BufferMetric> {
    private static final String BUFFER_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.buffer.DefaultBufferMetric";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public BufferMetricProvider() {
    }

    public BufferMetric get() {
        JvmVersion jvmVersion = JvmUtils.getVersion();
        if (!jvmVersion.onOrAfter(JvmVersion.JAVA_7)) {
            this.logger.debug("Unsupported JVM version. {}", (Object)jvmVersion);
            return BufferMetric.UNSUPPORTED_BUFFER_METRIC;
        }
        BufferMetric bufferMetric = this.createBufferMetric(BUFFER_METRIC);
        this.logger.info("loaded : {}", (Object)bufferMetric);
        return bufferMetric;
    }

    private BufferMetric createBufferMetric(String classToLoad) {
        if (classToLoad == null) {
            return BufferMetric.UNSUPPORTED_BUFFER_METRIC;
        }
        try {
            Class<?> bufferMetricClass = Class.forName(classToLoad);
            Constructor<?> bufferMetricConstructor = bufferMetricClass.getConstructor(new Class[0]);
            return (BufferMetric)bufferMetricConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.warn("BufferMetric initialize fail: {}", (Object)classToLoad, (Object)e);
            return BufferMetric.UNSUPPORTED_BUFFER_METRIC;
        }
    }
}

