/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.junit4;

import com.navercorp.pinpoint.bootstrap.logging.PLoggerBinder;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.logging.Slf4jLoggerBinder;
import com.navercorp.pinpoint.test.MockApplicationContextFactory;
import com.navercorp.pinpoint.test.classloader.TestClassLoader;
import com.navercorp.pinpoint.test.classloader.TestClassLoaderFactory;
import java.io.Closeable;
import java.io.IOException;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContext
implements Closeable {
    private static final String BASE_TEST_CLASS_NAME = "com.navercorp.pinpoint.test.junit4.BasePinpointTest";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PLoggerBinder loggerBinder = new Slf4jLoggerBinder();
    private final TestClassLoader classLoader;
    private final DefaultApplicationContext mockApplicationContext = this.createMockApplicationContext();
    private final Class<?> baseTestClass;

    public TestContext() {
        this.mockApplicationContext.start();
        this.classLoader = TestClassLoaderFactory.createTestClassLoader(this.mockApplicationContext);
        this.classLoader.initialize();
        try {
            this.baseTestClass = this.classLoader.loadClass(BASE_TEST_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private DefaultApplicationContext createMockApplicationContext() {
        this.logger.trace("agent create");
        MockApplicationContextFactory factory = new MockApplicationContextFactory();
        return factory.build("pinpoint.config");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DefaultApplicationContext getDefaultApplicationContext() {
        return this.mockApplicationContext;
    }

    public TestClass createTestClass(Class<?> testClass) {
        try {
            Class<?> testClazz = this.classLoader.loadClass(testClass.getName());
            return new TestClass(testClazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Class<?> getBaseTestClass() {
        return this.baseTestClass;
    }

    @Override
    public void close() throws IOException {
        if (this.mockApplicationContext != null) {
            this.mockApplicationContext.close();
        }
        PLoggerFactory.unregister((PLoggerBinder)this.loggerBinder);
    }
}

