/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.ASMClass;
import com.navercorp.pinpoint.profiler.instrument.ASMClassNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMEngine
implements InstrumentEngine {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final Instrumentation instrumentation;
    private final EngineComponent engineComponent;

    public ASMEngine(Instrumentation instrumentation, EngineComponent engineComponent) {
        this.instrumentation = (Instrumentation)Assert.requireNonNull((Object)instrumentation, (String)"instrumentation must not be null");
        this.engineComponent = (EngineComponent)Assert.requireNonNull((Object)engineComponent, (String)"engineComponent must not be null");
    }

    @Override
    public InstrumentClass getClass(InstrumentContext instrumentContext, ClassLoader classLoader, String className, ProtectionDomain protectionDomain, byte[] classFileBuffer) throws NotFoundInstrumentException {
        if (className == null) {
            throw new NullPointerException("class name must not be null.");
        }
        try {
            if (classFileBuffer == null) {
                ASMClassNodeAdapter classNode = ASMClassNodeAdapter.get(instrumentContext, classLoader, JavaAssistUtils.javaNameToJvmName(className));
                if (classNode == null) {
                    return null;
                }
                return new ASMClass(this.engineComponent, instrumentContext, classLoader, classNode);
            }
            ClassReader classReader = new ClassReader(classFileBuffer);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            return new ASMClass(this.engineComponent, instrumentContext, classLoader, classNode);
        }
        catch (Exception e) {
            throw new NotFoundInstrumentException((Throwable)e);
        }
    }

    @Override
    public void appendToBootstrapClassPath(JarFile jarFile) {
        if (jarFile == null) {
            throw new NullPointerException("jarFile must not be null");
        }
        if (this.isInfo) {
            this.logger.info("appendToBootstrapClassPath:{}", (Object)jarFile.getName());
        }
        this.instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
    }
}

