/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.navercorp.pinpoint.profiler.context.id.TraceRoot;

public class Item
implements Comparable<Item> {
    private final Object value;
    private final long time;
    private final long spanId;
    private final int sequence;
    private final int asyncId;
    private final int asyncSequence;
    private final TraceRoot traceRoot;

    public Item(Object value, long time, TraceRoot traceRoot, int sequence) {
        this(value, time, traceRoot, sequence, -1, -1);
    }

    public Item(Object value, long time, TraceRoot traceRoot, int sequence, int asyncId, int asyncSequence) {
        this.value = value;
        this.time = time;
        this.traceRoot = traceRoot;
        this.spanId = traceRoot.getTraceId().getSpanId();
        this.sequence = sequence;
        this.asyncId = asyncId;
        this.asyncSequence = asyncSequence;
    }

    public Object getValue() {
        return this.value;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    @Override
    public int compareTo(Item o) {
        if (this.asyncId == -1 && o.asyncId == -1) {
            return Item.compareItems(this, o);
        }
        if (this.asyncId != -1 && o.asyncId != -1) {
            return Item.compareAsyncItems(this, o);
        }
        if (this.asyncId == -1) {
            return -1;
        }
        return 1;
    }

    private static int compareItems(Item lhs, Item rhs) {
        if (lhs.time < rhs.time) {
            return -1;
        }
        if (lhs.time > rhs.time) {
            return 1;
        }
        if (lhs.spanId < rhs.spanId) {
            return -1;
        }
        if (lhs.spanId > rhs.spanId) {
            return 1;
        }
        if (lhs.sequence < rhs.sequence) {
            return -1;
        }
        if (lhs.sequence > rhs.sequence) {
            return 1;
        }
        return Item.compareHashes(lhs, rhs);
    }

    private static int compareAsyncItems(Item lhs, Item rhs) {
        if (lhs.asyncId < rhs.asyncId) {
            return -1;
        }
        if (lhs.asyncId > rhs.asyncId) {
            return 1;
        }
        if (lhs.asyncSequence < rhs.asyncSequence) {
            return -1;
        }
        if (lhs.asyncSequence > rhs.asyncSequence) {
            return 1;
        }
        if (lhs.sequence < rhs.sequence) {
            return -1;
        }
        if (lhs.sequence > rhs.sequence) {
            return 1;
        }
        return Item.compareHashes(lhs, rhs);
    }

    private static int compareHashes(Item lhs, Item rhs) {
        int h2;
        int h1 = System.identityHashCode(lhs.value);
        return h1 < (h2 = System.identityHashCode(rhs.value)) ? -1 : (h1 > h2 ? 1 : 0);
    }

    public String toString() {
        return "Item{value=" + this.value + ", time=" + this.time + ", spanId=" + this.spanId + ", sequence=" + this.sequence + ", asyncId=" + this.asyncId + ", asyncSequence=" + this.asyncSequence + ", traceRoot=" + this.traceRoot + '}';
    }
}

