#!/bin/bash
echo "java_start java"
module_name=project
package_path="`pwd`/${module_name}/app.jar"

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"

echo "nohup java -Xmx512m  -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} & " > java_command
java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path}