import requests
import time
import json
import os

def check():
    url = "http://192.168.29.116:9001/api/etcd/get_env_job_status"
    querystring = {"namespace": os.getenv('NAMESPACE')}

    headers = {}
    response = requests.request("GET", url, headers=headers, params=querystring)
    return json.loads(response.text)

count = 0
all_job_is_done = False
while True:
    res = check()
    for instance in res["details"]["instances"]:
        db_sync = instance["db_sync"]
        rabbitmq_sync = instance["rabbitmq_sync"]
        
        if db_sync == "done" and rabbitmq_sync == "done":
            print "All of the sync job is done!"
            all_job_is_done = True
        else:
            print "db_sync is:" + db_sync
            print "rabbitmq_sync is:" + rabbitmq_sync
    
    time.sleep(2)
    if count == 120 or all_job_is_done:
        break