/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hbase;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.hbase.HbasePluginConfig;
import com.navercorp.pinpoint.plugin.hbase.HbasePluginConstants;
import java.security.ProtectionDomain;

public class HbasePlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    public void setup(ProfilerPluginSetupContext context) {
        HbasePluginConfig config = new HbasePluginConfig(context.getConfig());
        if (!config.isClientProfile()) {
            this.logger.info("Disable HbasePlugin. config={}", (Object)config);
            return;
        }
        if (config.isAdminProfile()) {
            this.addHbaseAdminTransformer(config.isParamsProfile());
        }
        if (config.isTableProfile()) {
            this.addHbaseTableTransformer(config.isParamsProfile());
        }
        this.addHbaseClientTransformer();
    }

    private void addHbaseClientTransformer() {
        this.transformTemplate.transform("org.apache.hadoop.hbase.client.AsyncProcess", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"submit", "submitAll"}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.hbase.interceptor.HbaseClientMainInterceptor", "HBASE_CLIENT_SCOPE");
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.hadoop.hbase.client.AsyncProcess$AsyncRequestFutureImpl$SingleServerRequestRunnable", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod constructor = target.getConstructor(new String[]{"org.apache.hadoop.hbase.client.AsyncProcess$AsyncRequestFutureImpl", "org.apache.hadoop.hbase.client.MultiAction", "int", "org.apache.hadoop.hbase.ServerName", "java.util.Set"});
                constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.hbase.interceptor.HbaseClientConstructorInterceptor", "HBASE_CLIENT_SCOPE", ExecutionPolicy.INTERNAL);
                InstrumentMethod method = target.getDeclaredMethod("run", new String[0]);
                method.addInterceptor("com.navercorp.pinpoint.plugin.hbase.interceptor.HbaseClientRunInterceptor");
                return target.toBytecode();
            }
        });
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"call"}))) {
                    method.addInterceptor("com.navercorp.pinpoint.plugin.hbase.interceptor.HbaseClientMethodInterceptor");
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("org.apache.hadoop.hbase.ipc.RpcClientImpl", transformCallback);
        this.transformTemplate.transform("org.apache.hadoop.hbase.ipc.AsyncRpcClient", transformCallback);
    }

    private void addHbaseAdminTransformer(final boolean paramsProfile) {
        this.transformTemplate.transform("org.apache.hadoop.hbase.client.HBaseAdmin", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])HbasePluginConstants.adminMethodNames))) {
                    method.addInterceptor("com.navercorp.pinpoint.plugin.hbase.interceptor.HbaseAdminMethodInterceptor", VarArgs.va((Object[])new Object[]{paramsProfile}));
                }
                return target.toBytecode();
            }
        });
    }

    private void addHbaseTableTransformer(final boolean paramsProfile) {
        this.transformTemplate.transform("org.apache.hadoop.hbase.client.HTable", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])HbasePluginConstants.tableMethodNames))) {
                    method.addInterceptor("com.navercorp.pinpoint.plugin.hbase.interceptor.HbaseTableMethodInterceptor", VarArgs.va((Object[])new Object[]{paramsProfile}));
                }
                return target.toBytecode();
            }
        });
    }
}

