/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyHttpHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.vertx.ParameterRecorderFactory;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpHeaderFilter;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpServerConfig;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpServerMethodDescriptor;
import com.navercorp.pinpoint.plugin.vertx.interceptor.HttpServerRequestAdaptor;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;

public class ServerConnectionHandleRequestInterceptor
implements AroundInterceptor {
    private static final String SCOPE_NAME = "##VERTX_SERVER_CONNECTION_TRACE";
    private static final VertxHttpServerMethodDescriptor VERTX_HTTP_SERVER_METHOD_DESCRIPTOR = new VertxHttpServerMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isTrace = this.logger.isTraceEnabled();
    private final Filter<String> excludeUrlFilter;
    private final ProxyHttpHeaderRecorder<HttpServerRequest> proxyHttpHeaderRecorder;
    private final VertxHttpHeaderFilter httpHeaderFilter;
    private final ServerRequestRecorder<HttpServerRequest> serverRequestRecorder;
    private final RequestTraceReader<HttpServerRequest> requestTraceReader;
    private final ParameterRecorder<HttpServerRequest> parameterRecorder;
    private TraceContext traceContext;
    private MethodDescriptor descriptor;

    public ServerConnectionHandleRequestInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
        VertxHttpServerConfig config = new VertxHttpServerConfig(traceContext.getProfilerConfig());
        this.excludeUrlFilter = config.getExcludeUrlFilter();
        HttpServerRequestAdaptor requestAdaptor = new HttpServerRequestAdaptor();
        requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        this.parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.proxyHttpHeaderRecorder = new ProxyHttpHeaderRecorder(traceContext.getProfilerConfig().isProxyHttpHeaderEnable(), (RequestAdaptor)requestAdaptor);
        this.httpHeaderFilter = new VertxHttpHeaderFilter(config.isHidePinpointHeader());
        this.serverRequestRecorder = new ServerRequestRecorder((RequestAdaptor)requestAdaptor);
        this.requestTraceReader = new RequestTraceReader(traceContext, (RequestAdaptor)requestAdaptor, true);
        traceContext.cacheApi((MethodDescriptor)VERTX_HTTP_SERVER_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        block10: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if (this.traceContext.currentRawTraceObject() != null) {
                return;
            }
            try {
                if (!this.validate(args)) {
                    return;
                }
                HttpServerRequest request = (HttpServerRequest)args[0];
                HttpServerResponse response = request.response();
                if (!(response instanceof AsyncContextAccessor)) {
                    if (this.isDebug) {
                        this.logger.debug("Invalid response. Need metadata accessor({}).", (Object)AsyncContextAccessor.class.getName());
                    }
                    return;
                }
                Trace trace = this.createTrace(request);
                if (trace == null) {
                    return;
                }
                this.entryScope(trace);
                this.httpHeaderFilter.filter(request);
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(VertxConstants.VERTX_HTTP_SERVER_INTERNAL);
                AsyncContext asyncContext = recorder.recordNextAsyncContext(true);
                ((AsyncContextAccessor)request)._$PINPOINT$_setAsyncContext(asyncContext);
                ((AsyncContextAccessor)response)._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set closeable-AsyncContext {}", (Object)asyncContext);
                }
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block10;
                this.logger.warn("BEFORE. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 1) {
            if (this.isDebug) {
                this.logger.debug("Invalid args object. args={}.", args);
            }
            return false;
        }
        if (!(args[0] instanceof HttpServerRequest)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. {}.", args[0]);
            }
            return false;
        }
        if (!(args[0] instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. Need metadata accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!this.hasScope(trace)) {
            return;
        }
        if (!this.leaveScope(trace)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Failed to leave scope. trace={}, sampled={}", (Object)trace, (Object)trace.canSampled());
            }
            this.deleteTrace(trace);
            return;
        }
        if (!this.isEndScope(trace)) {
            return;
        }
        if (!trace.canSampled()) {
            this.deleteTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            if (this.validate(args)) {
                HttpServerRequest request = (HttpServerRequest)args[0];
                this.parameterRecorder.record(recorder, (Object)request, throwable);
            }
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
        finally {
            trace.traceBlockEnd();
            this.deleteTrace(trace);
        }
    }

    private Trace createTrace(HttpServerRequest request) {
        String requestURI = request.path();
        if (requestURI != null && this.excludeUrlFilter.filter((Object)requestURI)) {
            if (this.isTrace) {
                this.logger.trace("filter requestURI:{}", (Object)requestURI);
            }
            return null;
        }
        Trace trace = this.requestTraceReader.read((Object)request);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(VertxConstants.VERTX_HTTP_SERVER);
            recorder.recordApi((MethodDescriptor)VERTX_HTTP_SERVER_METHOD_DESCRIPTOR);
            this.serverRequestRecorder.record(recorder, (Object)request);
            this.proxyHttpHeaderRecorder.record(recorder, (Object)request);
        }
        if (!this.initScope(trace)) {
            this.deleteTrace(trace);
            return null;
        }
        return trace;
    }

    private void deleteTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
    }

    private boolean initScope(Trace trace) {
        TraceScope oldScope = trace.addScope(SCOPE_NAME);
        if (oldScope != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Duplicated trace scope={}.", (Object)oldScope.getName());
            }
            return false;
        }
        return true;
    }

    private void entryScope(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        if (scope != null) {
            scope.tryEnter();
            if (this.isDebug) {
                this.logger.debug("Try enter trace scope={}", (Object)scope.getName());
            }
        }
    }

    private boolean leaveScope(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
                if (this.isDebug) {
                    this.logger.debug("Leave trace scope={}", (Object)scope.getName());
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean hasScope(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        return scope != null;
    }

    private boolean isEndScope(Trace trace) {
        TraceScope scope = trace.getScope(SCOPE_NAME);
        return scope != null && !scope.isActive();
    }
}

