/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.common.util.Assert;
import java.lang.reflect.Method;

public class AccessorAnalyzer {
    public AccessorDetails analyze(Class<?> accessorType) {
        Method setter;
        Method getter;
        Assert.requireNonNull(accessorType, (String)"accessorType");
        if (!accessorType.isInterface()) {
            throw new IllegalArgumentException("accessorType " + accessorType + "is not an interface");
        }
        Method[] methods = accessorType.getDeclaredMethods();
        if (methods.length != 2) {
            throw new IllegalArgumentException("accessorType has to declare 2 methods. " + accessorType + " has " + methods.length + ".");
        }
        if (methods[0].getParameterTypes().length == 0) {
            getter = methods[0];
            setter = methods[1];
        } else {
            getter = methods[1];
            setter = methods[0];
        }
        Class<?> fieldType = getter.getReturnType();
        if (fieldType == Void.TYPE || fieldType == Void.class) {
            throw new IllegalArgumentException("accessorType must declare an getter and setter: " + accessorType);
        }
        Class<?>[] setterParamTypes = setter.getParameterTypes();
        if (setterParamTypes.length != 1) {
            throw new IllegalArgumentException("accessorType must declare an getter and setter: " + accessorType);
        }
        if (setterParamTypes[0] != fieldType) {
            throw new IllegalArgumentException("The return type of getter is different to the parameter type of setter: " + accessorType);
        }
        if (setter.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("Setter must have return type void: " + accessorType);
        }
        return new AccessorDetails(fieldType, getter, setter);
    }

    public static class AccessorDetails {
        private final Class<?> fieldType;
        private final Method getter;
        private final Method setter;

        public AccessorDetails(Class<?> fieldType, Method getter, Method setter) {
            this.fieldType = fieldType;
            this.getter = getter;
            this.setter = setter;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }
    }
}

