/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.compress;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.compress.Context;
import com.navercorp.pinpoint.profiler.context.compress.ContextV1;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessor;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import java.util.List;

public class SpanPostProcessorV1
implements SpanPostProcessor<Context> {
    private static final byte V1 = TraceDataFormatVersion.V1.getVersion();

    @Override
    public Context newContext(Span span, TSpan tSpan) {
        if (tSpan.getVersion() == V1) {
            tSpan.setVersion(V1);
        }
        long startTime = span.getStartTime();
        return new ContextV1(startTime);
    }

    @Override
    public Context newContext(SpanChunk spanChunk, TSpanChunk tSpanChunk) {
        List<SpanEvent> spanEventList;
        if (tSpanChunk.getVersion() == V1) {
            tSpanChunk.setVersion(V1);
        }
        if (CollectionUtils.isEmpty(spanEventList = spanChunk.getSpanEventList())) {
            throw new IllegalStateException("spanEventList is empty");
        }
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        long traceStartTime = traceRoot.getTraceStartTime();
        return new ContextV1(traceStartTime);
    }

    @Override
    public void postProcess(Context context, SpanEvent spanEvent, TSpanEvent tSpanEvent) {
        long startTime = spanEvent.getStartTime();
        long keyTime = context.keyTime();
        long startElapsedTime = startTime - keyTime;
        tSpanEvent.setStartElapsed((int)startElapsedTime);
    }
}

