/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resin;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.resin.ResinConfig;
import com.navercorp.pinpoint.plugin.resin.ResinDetector;
import java.security.ProtectionDomain;

public class ResinPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        ResinConfig config = new ResinConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("ResinPlugin disabled");
            return;
        }
        this.logger.info("ResinPlugin config:{}", (Object)config);
        ResinDetector resinDetector = new ResinDetector(config.getBootstrapMains());
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{resinDetector});
        this.logger.info("Adding Resin transformers");
        this.addTransformers(config);
    }

    private void addTransformers(ResinConfig config) {
        this.addWebApp();
        this.addHttpServletRequestImpl(config);
        this.addServletInvocation();
    }

    private void addWebApp() {
        this.transformTemplate.transform("com.caucho.server.webapp.WebApp", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod initMethodEditorBuilder = target.getDeclaredMethod("init", new String[0]);
                if (initMethodEditorBuilder != null) {
                    initMethodEditorBuilder.addInterceptor("com.navercorp.pinpoint.plugin.resin.interceptor.WebAppInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpServletRequestImpl(final ResinConfig config) {
        this.transformTemplate.transform("com.caucho.server.http.HttpServletRequestImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod startAsyncMethodEditor;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (config.isHidePinpointHeader()) {
                    target.weave("com.navercorp.pinpoint.plugin.resin.aspect.HttpServletRequestImplAspect");
                }
                if ((startAsyncMethodEditor = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"})) != null) {
                    startAsyncMethodEditor.addInterceptor("com.navercorp.pinpoint.plugin.resin.interceptor.HttpServletRequestImplInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addServletInvocation() {
        this.transformTemplate.transform("com.caucho.server.dispatch.ServletInvocation", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod serviceMethodEditorBuilder = target.getDeclaredMethod("service", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"});
                if (serviceMethodEditorBuilder != null) {
                    serviceMethodEditorBuilder.addScopedInterceptor("com.navercorp.pinpoint.plugin.resin.interceptor.ServletInvocationServiceInterceptor", "RESIN_REQUEST", ExecutionPolicy.BOUNDARY);
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

