/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.MapUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientConstants;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientPluginConfig;
import com.navercorp.pinpoint.plugin.rabbitmq.client.descriptor.RabbitMQConsumerEntryMethodDescriptor;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.LocalAddressAccessor;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.RemoteAddressAccessor;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.Method;
import java.util.Collections;
import java.util.Map;

public class RabbitMQConsumerHandleCompleteInboundCommandInterceptor
implements AroundInterceptor {
    private static final RabbitMQConsumerEntryMethodDescriptor CONSUMER_ENTRY_METHOD_DESCRIPTOR = new RabbitMQConsumerEntryMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final Filter<String> excludeExchangeFilter;

    public RabbitMQConsumerHandleCompleteInboundCommandInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, Filter<String> excludeExchangeFilter) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.excludeExchangeFilter = excludeExchangeFilter;
        this.traceContext.cacheApi((MethodDescriptor)CONSUMER_ENTRY_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        block7: {
            if (!this.validate(target, args)) {
                return;
            }
            AMQCommand command = (AMQCommand)args[0];
            Method method = command.getMethod();
            if (!(method instanceof AMQP.Basic.GetOk)) {
                return;
            }
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                AMQChannel channel = (AMQChannel)target;
                Trace trace = this.createTrace(channel, command);
                if (trace == null) {
                    return;
                }
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(RabbitMQClientConstants.RABBITMQ_CLIENT_INTERNAL);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (!this.validate(target, args)) {
            return;
        }
        AMQCommand command = (AMQCommand)args[0];
        Method method = command.getMethod();
        if (!(method instanceof AMQP.Basic.GetOk)) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.traceContext.removeTraceObject();
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            this.traceContext.removeTraceObject();
            trace.traceBlockEnd();
            trace.close();
        }
    }

    private Trace createTrace(AMQChannel amqChannel, AMQCommand amqCommand) {
        Trace trace;
        Method method;
        AMQP.Basic.GetOk getOk;
        String exchange;
        AMQConnection connection = amqChannel.getConnection();
        if (connection == null) {
            this.logger.debug("connection is null, skipping trace");
        }
        if (RabbitMQClientPluginConfig.isExchangeExcluded(exchange = (getOk = (AMQP.Basic.GetOk)(method = amqCommand.getMethod())).getExchange(), this.excludeExchangeFilter)) {
            if (this.isDebug) {
                this.logger.debug("exchange {} is excluded", (Object)exchange);
            }
            return null;
        }
        String routingKey = getOk.getRoutingKey();
        Map<String, Object> headers = this.getHeadersFromContentHeader(amqCommand.getContentHeader());
        if (headers.get("Pinpoint-Sampled") != null) {
            return this.traceContext.disableSampling();
        }
        TraceId traceId = this.populateTraceIdFromRequest(headers);
        Trace trace2 = trace = traceId == null ? this.traceContext.newTraceObject() : this.traceContext.continueTraceObject(traceId);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            this.recordRootSpan(recorder, connection, exchange, routingKey, headers);
        }
        return trace;
    }

    private Map<String, Object> getHeadersFromContentHeader(AMQContentHeader amqContentHeader) {
        if (!(amqContentHeader instanceof AMQP.BasicProperties)) {
            return Collections.emptyMap();
        }
        AMQP.BasicProperties properties = (AMQP.BasicProperties)amqContentHeader;
        Map headers = properties.getHeaders();
        if (headers == null) {
            return Collections.emptyMap();
        }
        return headers;
    }

    private TraceId populateTraceIdFromRequest(Map<String, Object> headers) {
        Object transactionId = headers.get("Pinpoint-TraceID");
        if (transactionId == null) {
            return null;
        }
        long parentSpanId = NumberUtils.parseLong((String)headers.get("Pinpoint-pSpanID").toString(), (long)-1L);
        long spanId = NumberUtils.parseLong((String)headers.get("Pinpoint-SpanID").toString(), (long)-1L);
        short flags = NumberUtils.parseShort((String)headers.get("Pinpoint-Flags").toString(), (short)0);
        return this.traceContext.createTraceId(transactionId.toString(), parentSpanId, spanId, flags);
    }

    private void recordRootSpan(SpanRecorder recorder, AMQConnection amqConnection, String exchange, String routingKey, Map<String, Object> headers) {
        recorder.recordServiceType(RabbitMQClientConstants.RABBITMQ_CLIENT);
        recorder.recordApi((MethodDescriptor)CONSUMER_ENTRY_METHOD_DESCRIPTOR);
        String endPoint = "Unknown";
        String remoteAddress = "Unknown";
        if (amqConnection != null) {
            FrameHandler frameHandler = amqConnection.getFrameHandler();
            if (frameHandler instanceof LocalAddressAccessor) {
                endPoint = ((LocalAddressAccessor)frameHandler)._$PINPOINT$_getLocalAddress();
            }
            if (frameHandler instanceof RemoteAddressAccessor) {
                remoteAddress = ((RemoteAddressAccessor)frameHandler)._$PINPOINT$_getRemoteAddress();
            }
        }
        recorder.recordEndPoint(endPoint);
        recorder.recordRemoteAddress(remoteAddress);
        String convertedExchange = exchange;
        if (StringUtils.isEmpty((String)convertedExchange)) {
            convertedExchange = "Unknown";
        }
        recorder.recordRpcName("rabbitmq://exchange=" + convertedExchange);
        recorder.recordAcceptorHost("exchange-" + convertedExchange);
        if (this.isDebug) {
            this.logger.debug("endPoint={}->{}", (Object)exchange, (Object)convertedExchange);
        }
        recorder.recordAttribute(RabbitMQClientConstants.RABBITMQ_ROUTINGKEY_ANNOTATION_KEY, routingKey);
        if (!MapUtils.isEmpty(headers)) {
            Object parentApplicationName = headers.get("Pinpoint-pAppName");
            if (!recorder.isRoot() && parentApplicationName != null) {
                Object parentApplicationType = headers.get("Pinpoint-pAppType");
                recorder.recordParentApplication(parentApplicationName.toString(), NumberUtils.parseShort((String)parentApplicationType.toString(), (short)ServiceType.UNDEFINED.getCode()));
            }
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        if (!(target instanceof AMQChannel)) {
            if (this.isDebug) {
                this.logger.debug("Expected target to be of type AMQChannel, but was {}", (Object)target.getClass().getName());
            }
            return false;
        }
        if (!(args[0] instanceof AMQCommand)) {
            if (this.isDebug) {
                String args0 = args[0] == null ? "null" : args[0].getClass().getName();
                this.logger.debug("Expected args[0] to be of type AMQCommand, but was {}", (Object)args0);
            }
            return false;
        }
        return true;
    }
}

