/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class GrpcConfig {
    static final String CLIENT_ENABLE = "profiler.grpc.client.enable";
    static final String SERVER_ENABLE = "profiler.grpc.server.enable";
    static final String SERVER_STREAMING_ENABLE = "profiler.grpc.server.streaming.enable";
    static final String SERVER_STREAMING_ON_MESSAGE_ENABLE = "profiler.grpc.server.streaming.onmessage.enable";
    private final boolean clientEnable;
    private final boolean serverEnable;
    private final boolean serverStreamingEnable;
    private final boolean serverStreamingOnMessageEnable;

    public GrpcConfig(ProfilerConfig config) {
        this.clientEnable = config.readBoolean(CLIENT_ENABLE, false);
        this.serverEnable = config.readBoolean(SERVER_ENABLE, false);
        this.serverStreamingEnable = config.readBoolean(SERVER_STREAMING_ENABLE, false);
        this.serverStreamingOnMessageEnable = config.readBoolean(SERVER_STREAMING_ON_MESSAGE_ENABLE, false);
    }

    public boolean isClientEnable() {
        return this.clientEnable;
    }

    public boolean isServerEnable() {
        return this.serverEnable;
    }

    public boolean isServerStreamingEnable() {
        return this.serverStreamingEnable;
    }

    public boolean isServerStreamingOnMessageEnable() {
        return this.serverStreamingOnMessageEnable;
    }
}

