#!/bin/bash
echo "java_start java"
module_name=project
package_path="`pwd`/${module_name}/app.jar"
config_path="`pwd`/${module_name}/application.properties"

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"

echo 192.168.6.13 eos.quantgroups.com >> /etc/hosts
echo 192.168.4.117 apollo-dev.quantgroups.com >> /etc/hosts

sed -i "s#.xyqb.com#-$NAMESPACE.q-gp.com#g" ${config_path}
sed -i "s#.domain.com#-$NAMESPACE.q-gp.com#g" ${config_path}
sed -i "s#.quantgroup.cn#-$NAMESPACE.q-gp.com#g" ${config_path}

sed -i "s#xterm.js demo#${SYSTEM_NAME}@${NAMESPACE}#"  /home/qg-xterm/demo/index.html


if [[ $CLUSTER == "pro" ]]; then
	#初始化变量
	export DB_SERVICE_HOST="192.168.4.15"
	export RABBIT_SERVICE_HOST="192.168.4.15"
	export REDIS_SERVICE_HOST="192.168.4.15"
	export ZOOKEEPER_SERVICE_HOST="192.168.4.15"
	
	echo "nohup java -Xmx512m  -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} & " > java_command
	nohup java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s -Dtest=true -Dlogging.config=classpath:logback-pro.xml -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} >/dev/null 2>&1 &
else
	echo "nohup java -Xmx512m  -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} & " > java_command
	nohup java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -Dlogging.config=classpath:logback-pro.xml -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} >/dev/null 2>&1 &
fi

# waiting for log
count=0
log_exist=0
log_path="/home/quant_group/logs"
until [[ $count -eq 60 ]] || [[ $log_exist -eq 1 ]]
do
  let count+=1
  echo "count is $count"
  
  if find "$log_path" -mindepth 1 -print -quit | grep -q .; then
      echo "log is exist!"
	  log_exist=1
  else
      echo "log is not exist! waiting for server start."
	  touch ./logs/tmp.log
  fi
  sleep 1
done

echo "cd /home/qg-xterm/;git pull;cd -"
cd /home/qg-xterm/;git pull;cd -

echo "node /home/qg-xterm/demo/app.js"
nohup node /home/qg-xterm/demo/app.js &

echo "frontail ./logs/*log -n 500 -d "
frontail ./logs/*log -n 500

# echo "tail -f ./logs/*log"
# tail -f ./logs/*log