/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.collections.CollectionUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver.DefaultEntityResolver;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver.EntityRegistry;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
extends AbstractHierarchicalFileConfiguration
implements EntityRegistry,
EntityResolver {
    private static final long serialVersionUID = 2453781111653383552L;
    private static final String DEFAULT_ROOT_NAME = "configuration";
    private static final String ATTR_SPACE = "xml:space";
    private static final String VALUE_PRESERVE = "preserve";
    private static final char ATTR_VALUE_DELIMITER = '|';
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Document document;
    private String rootElementName;
    private String publicID;
    private String systemID;
    private DocumentBuilder documentBuilder;
    private boolean validating;
    private boolean schemaValidation;
    private boolean attributeSplittingDisabled;
    private EntityResolver entityResolver = new DefaultEntityResolver();

    public XMLConfiguration() {
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        super(hierarchicalConfiguration);
        XMLConfiguration.clearReferences(this.getRootNode());
        this.setRootElementName(this.getRootNode().getName());
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(String string) throws ConfigurationException {
        super(string);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public String getRootElementName() {
        if (this.getDocument() == null) {
            return this.rootElementName == null ? DEFAULT_ROOT_NAME : this.rootElementName;
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public void setRootElementName(String string) {
        if (this.getDocument() != null) {
            throw new UnsupportedOperationException("The name of the root element cannot be changed when loaded from an XML document!");
        }
        this.rootElementName = string;
        this.getRootNode().setName(string);
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String string) {
        this.publicID = string;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String string) {
        this.systemID = string;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean bl) {
        if (!this.schemaValidation) {
            this.validating = bl;
        }
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean bl) {
        this.schemaValidation = bl;
        if (bl) {
            this.validating = true;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public boolean isAttributeSplittingDisabled() {
        return this.attributeSplittingDisabled;
    }

    public void setAttributeSplittingDisabled(boolean bl) {
        this.attributeSplittingDisabled = bl;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void clear() {
        super.clear();
        this.setRoot(new HierarchicalConfiguration.Node());
        this.document = null;
    }

    public void initProperties(Document document, boolean bl) {
        if (document.getDoctype() != null) {
            this.setPublicID(document.getDoctype().getPublicId());
            this.setSystemID(document.getDoctype().getSystemId());
        }
        this.constructHierarchy(this.getRoot(), document.getDocumentElement(), bl, true);
        this.getRootNode().setName(document.getDocumentElement().getNodeName());
        if (bl) {
            this.getRoot().setReference(document.getDocumentElement());
        }
    }

    private Map<String, Collection<String>> constructHierarchy(HierarchicalConfiguration.Node node, Element element, boolean bl, boolean bl2) {
        boolean bl3 = this.shouldTrim(element, bl2);
        Map<String, Collection<String>> map = this.processAttributes(node, element, bl);
        map.put(ATTR_SPACE, Collections.singleton(String.valueOf(bl3)));
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node3 = nodeList.item(i);
            if (node3 instanceof Element) {
                node2 = (Element)node3;
                XMLNode xMLNode = new XMLNode(node2.getTagName(), (Element)(bl ? node2 : null));
                Map<String, Collection<String>> map2 = this.constructHierarchy(xMLNode, (Element)node2, bl, bl3);
                node.addChild(xMLNode);
                Collection<String> collection = map2.remove(ATTR_SPACE);
                Boolean bl4 = CollectionUtils.isEmpty(collection) ? Boolean.FALSE : Boolean.valueOf(collection.iterator().next());
                this.handleDelimiters(node, xMLNode, bl4, map2);
                continue;
            }
            if (!(node3 instanceof Text)) continue;
            node2 = (Text)node3;
            stringBuilder.append(node2.getData());
        }
        String string = XMLConfiguration.determineValue(node, stringBuilder.toString(), bl3);
        if (string.length() > 0 || !node.hasChildren() && node != this.getRoot()) {
            node.setValue(string);
        }
        return map;
    }

    private static String determineValue(ConfigurationNode configurationNode, String string, boolean bl) {
        boolean bl2 = bl || StringUtils.isBlank(string) && configurationNode.getChildrenCount() > 0;
        return bl2 ? string.trim() : string;
    }

    private Map<String, Collection<String>> processAttributes(HierarchicalConfiguration.Node node, Element element, boolean bl) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!(node2 instanceof Attr)) continue;
            Attr attr = (Attr)node2;
            List<String> list = this.isAttributeSplittingDisabled() ? Collections.singletonList(attr.getValue()) : PropertyConverter.split(attr.getValue(), this.isDelimiterParsingDisabled() ? (char)'|' : (char)this.getListDelimiter());
            this.appendAttributes(node, element, bl, attr.getName(), list);
            hashMap.put(attr.getName(), list);
        }
        return hashMap;
    }

    private void appendAttributes(HierarchicalConfiguration.Node node, Element element, boolean bl, String string, Collection<String> collection) {
        for (String string2 : collection) {
            XMLNode xMLNode = new XMLNode(string, bl ? element : null);
            ((DefaultConfigurationNode)xMLNode).setValue(string2);
            node.addAttribute(xMLNode);
        }
    }

    private void handleDelimiters(HierarchicalConfiguration.Node node, HierarchicalConfiguration.Node node2, boolean bl, Map<String, Collection<String>> map) {
        if (node2.getValue() != null) {
            List<Object> list;
            if (this.isDelimiterParsingDisabled()) {
                list = new ArrayList<String>();
                list.add(node2.getValue().toString());
            } else {
                list = PropertyConverter.split(node2.getValue().toString(), this.getListDelimiter(), bl);
            }
            if (list.size() > 1) {
                Iterator<Object> iterator = list.iterator();
                HierarchicalConfiguration.Node node3 = this.createNode(node2.getName());
                node3.setValue(iterator.next());
                for (ConfigurationNode object : node2.getAttributes()) {
                    object.setReference(null);
                    node3.addAttribute(object);
                }
                node.remove(node2);
                node.addChild(node3);
                while (iterator.hasNext()) {
                    node3 = new XMLNode(node2.getName(), null);
                    node3.setValue(iterator.next());
                    for (Map.Entry entry : map.entrySet()) {
                        this.appendAttributes(node3, null, false, (String)entry.getKey(), (Collection)entry.getValue());
                    }
                    node.addChild(node3);
                }
            } else if (list.size() == 1) {
                node2.setValue(list.get(0));
            }
        }
    }

    private boolean shouldTrim(Element element, boolean bl) {
        Attr attr = element.getAttributeNode(ATTR_SPACE);
        if (attr == null) {
            return bl;
        }
        return !VALUE_PRESERVE.equals(attr.getValue());
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.getDocumentBuilder() != null) {
            return this.getDocumentBuilder();
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (this.isValidating()) {
            documentBuilderFactory.setValidating(true);
            if (this.isSchemaValidation()) {
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
        }
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(this.entityResolver);
        if (this.isValidating()) {
            documentBuilder.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
        }
        return documentBuilder;
    }

    protected Document createDocument() throws ConfigurationException {
        try {
            Object object;
            if (this.document == null) {
                object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = ((DocumentBuilder)object).newDocument();
                Element element = document.createElement(this.getRootElementName());
                document.appendChild(element);
                this.document = document;
            }
            object = new XMLBuilderVisitor(this.document, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter(), this.isAttributeSplittingDisabled());
            ((XMLBuilderVisitor)object).processDocument(this.getRoot());
            this.initRootElementText(this.document, this.getRootNode().getValue());
            return this.document;
        }
        catch (DOMException dOMException) {
            throw new ConfigurationException(dOMException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationException(parserConfigurationException);
        }
    }

    private void initRootElementText(Document document, Object object) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            element.removeChild(node);
        }
        if (object != null) {
            element.appendChild(document.createTextNode(String.valueOf(object)));
        }
    }

    @Override
    protected HierarchicalConfiguration.Node createNode(String string) {
        return new XMLNode(string, null);
    }

    @Override
    public void load(InputStream inputStream) throws ConfigurationException {
        this.load(new InputSource(inputStream));
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        this.load(new InputSource(reader));
    }

    private void load(InputSource inputSource) throws ConfigurationException {
        try {
            URL uRL = this.getDelegate().getURL();
            if (uRL != null) {
                inputSource.setSystemId(uRL.toString());
            }
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            Document document2 = this.document;
            this.document = null;
            this.initProperties(document, document2 == null);
            this.document = document2 == null ? document : document2;
        }
        catch (SAXParseException sAXParseException) {
            throw new ConfigurationException("Error parsing " + inputSource.getSystemId(), sAXParseException);
        }
        catch (Exception exception) {
            this.getLogger().debug("Unable to load the configuraton", exception);
            throw new ConfigurationException("Unable to load the configuration", exception);
        }
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource dOMSource = new DOMSource(this.createDocument());
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new ConfigurationException("Unable to save the configuration", transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new ConfigurationException("Unable to save the configuration", transformerFactoryConfigurationError);
        }
    }

    public void validate() throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource dOMSource = new DOMSource(this.createDocument());
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            documentBuilder.parse(new InputSource(stringReader));
        }
        catch (SAXException sAXException) {
            throw new ConfigurationException("Validation failed", sAXException);
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Validation failed", iOException);
        }
        catch (TransformerException transformerException) {
            throw new ConfigurationException("Validation failed", transformerException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationException("Validation failed", parserConfigurationException);
        }
    }

    protected Transformer createTransformer() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (this.getEncoding() != null) {
            transformer.setOutputProperty("encoding", this.getEncoding());
        }
        if (this.getPublicID() != null) {
            transformer.setOutputProperty("doctype-public", this.getPublicID());
        }
        if (this.getSystemID() != null) {
            transformer.setOutputProperty("doctype-system", this.getSystemID());
        }
        return transformer;
    }

    @Override
    public Object clone() {
        XMLConfiguration xMLConfiguration = (XMLConfiguration)super.clone();
        xMLConfiguration.document = null;
        xMLConfiguration.setDelegate(xMLConfiguration.createDelegate());
        XMLConfiguration.clearReferences(xMLConfiguration.getRootNode());
        return xMLConfiguration;
    }

    @Override
    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new XMLFileConfigurationDelegate();
    }

    @Override
    public void addNodes(String string, Collection<? extends ConfigurationNode> collection) {
        if (collection != null && !collection.isEmpty()) {
            ArrayList<XMLNode> arrayList = new ArrayList<XMLNode>(collection.size());
            for (ConfigurationNode configurationNode : collection) {
                arrayList.add(this.convertToXMLNode(configurationNode));
            }
            super.addNodes(string, arrayList);
        } else {
            super.addNodes(string, collection);
        }
    }

    private XMLNode convertToXMLNode(ConfigurationNode configurationNode) {
        if (configurationNode instanceof XMLNode) {
            return (XMLNode)configurationNode;
        }
        XMLNode xMLNode = (XMLNode)this.createNode(configurationNode.getName());
        xMLNode.setValue(configurationNode.getValue());
        xMLNode.setAttribute(configurationNode.isAttribute());
        for (ConfigurationNode configurationNode2 : configurationNode.getChildren()) {
            xMLNode.addChild(this.convertToXMLNode(configurationNode2));
        }
        for (ConfigurationNode configurationNode2 : configurationNode.getAttributes()) {
            xMLNode.addAttribute(this.convertToXMLNode(configurationNode2));
        }
        return xMLNode;
    }

    @Override
    public void registerEntityId(String string, URL uRL) {
        if (this.entityResolver instanceof EntityRegistry) {
            ((EntityRegistry)((Object)this.entityResolver)).registerEntityId(string, uRL);
        }
    }

    @Override
    @Deprecated
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            return this.entityResolver.resolveEntity(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public Map<String, URL> getRegisteredEntities() {
        if (this.entityResolver instanceof EntityRegistry) {
            return ((EntityRegistry)((Object)this.entityResolver)).getRegisteredEntities();
        }
        return new HashMap<String, URL>();
    }

    private class XMLFileConfigurationDelegate
    extends AbstractHierarchicalFileConfiguration.FileConfigurationDelegate {
        private XMLFileConfigurationDelegate() {
        }

        public void load(InputStream inputStream) throws ConfigurationException {
            XMLConfiguration.this.load(inputStream);
        }
    }

    static class XMLBuilderVisitor
    extends HierarchicalConfiguration.BuilderVisitor {
        private Document document;
        private final char listDelimiter;
        private boolean isAttributeSplittingDisabled;

        public XMLBuilderVisitor(Document document, char c2, boolean bl) {
            this.document = document;
            this.listDelimiter = c2;
            this.isAttributeSplittingDisabled = bl;
        }

        public void processDocument(HierarchicalConfiguration.Node node) {
            node.visit(this, null);
        }

        protected Object insert(HierarchicalConfiguration.Node node, HierarchicalConfiguration.Node node2, HierarchicalConfiguration.Node node3, HierarchicalConfiguration.Node node4) {
            if (node.isAttribute()) {
                XMLBuilderVisitor.updateAttribute(node2, this.getElement(node2), node.getName(), this.listDelimiter, this.isAttributeSplittingDisabled);
                return null;
            }
            Element element = this.document.createElement(node.getName());
            if (node.getValue() != null) {
                String string = node.getValue().toString();
                if (this.listDelimiter != '\u0000') {
                    string = PropertyConverter.escapeListDelimiter(string, this.listDelimiter);
                }
                element.appendChild(this.document.createTextNode(string));
            }
            if (node4 == null) {
                this.getElement(node2).appendChild(element);
            } else if (node3 != null) {
                this.getElement(node2).insertBefore(element, this.getElement(node3).getNextSibling());
            } else {
                this.getElement(node2).insertBefore(element, this.getElement(node2).getFirstChild());
            }
            return element;
        }

        private static void updateAttribute(HierarchicalConfiguration.Node node, Element element, String string, char c2, boolean bl) {
            if (node != null && element != null) {
                boolean bl2 = false;
                List<ConfigurationNode> list = node.getAttributes(string);
                StringBuilder stringBuilder = new StringBuilder();
                char c3 = c2 != '\u0000' ? c2 : (char)'|';
                for (ConfigurationNode configurationNode : list) {
                    if (configurationNode.getValue() != null) {
                        bl2 = true;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(c3);
                        }
                        String string2 = bl ? configurationNode.getValue().toString() : PropertyConverter.escapeDelimiters(configurationNode.getValue().toString(), c3);
                        stringBuilder.append(string2);
                    }
                    configurationNode.setReference(element);
                }
                if (!bl2) {
                    element.removeAttribute(string);
                } else {
                    element.setAttribute(string, stringBuilder.toString());
                }
            }
        }

        static void updateAttribute(HierarchicalConfiguration.Node node, String string, char c2, boolean bl) {
            if (node != null) {
                XMLBuilderVisitor.updateAttribute(node, (Element)node.getReference(), string, c2, bl);
            }
        }

        private Element getElement(HierarchicalConfiguration.Node node) {
            return node.getName() != null && node.getReference() != null ? (Element)node.getReference() : this.document.getDocumentElement();
        }
    }

    class XMLNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -4133988932174596562L;

        public XMLNode(String string, Element element) {
            super(string);
            this.setReference(element);
        }

        public void setValue(Object object) {
            super.setValue(object);
            if (this.getReference() != null && XMLConfiguration.this.document != null) {
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    this.updateElement(object);
                }
            }
        }

        protected void removeReference() {
            if (this.getReference() != null) {
                Element element = (Element)this.getReference();
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    Node node = element.getParentNode();
                    if (node != null) {
                        node.removeChild(element);
                    }
                }
            }
        }

        private void updateElement(Object object) {
            Text text = this.findTextNodeForUpdate();
            if (object == null) {
                if (text != null) {
                    ((Element)this.getReference()).removeChild(text);
                }
            } else if (text == null) {
                String string = XMLConfiguration.this.isDelimiterParsingDisabled() ? object.toString() : PropertyConverter.escapeDelimiters(object.toString(), XMLConfiguration.this.getListDelimiter());
                text = XMLConfiguration.this.document.createTextNode(string);
                if (((Element)this.getReference()).getFirstChild() != null) {
                    ((Element)this.getReference()).insertBefore(text, ((Element)this.getReference()).getFirstChild());
                } else {
                    ((Element)this.getReference()).appendChild(text);
                }
            } else {
                String string = XMLConfiguration.this.isDelimiterParsingDisabled() ? object.toString() : PropertyConverter.escapeDelimiters(object.toString(), XMLConfiguration.this.getListDelimiter());
                text.setNodeValue(string);
            }
        }

        private void updateAttribute() {
            XMLBuilderVisitor.updateAttribute(this.getParent(), this.getName(), XMLConfiguration.this.getListDelimiter(), XMLConfiguration.this.isAttributeSplittingDisabled());
        }

        private Text findTextNodeForUpdate() {
            Text text = null;
            Element element = (Element)this.getReference();
            NodeList nodeList = element.getChildNodes();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Text)) continue;
                if (text == null) {
                    text = (Text)node;
                    continue;
                }
                arrayList.add(node);
            }
            if (text instanceof CDATASection) {
                arrayList.add(text);
                text = null;
            }
            for (Node node : arrayList) {
                element.removeChild(node);
            }
            return text;
        }
    }
}

