/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubnodeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.BeanDeclaration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBeanDeclaration
implements BeanDeclaration {
    public static final String RESERVED_PREFIX = "config-";
    public static final String ATTR_PREFIX = "[@config-";
    public static final String ATTR_BEAN_CLASS = "[@config-class]";
    public static final String ATTR_BEAN_FACTORY = "[@config-factory]";
    public static final String ATTR_FACTORY_PARAM = "[@config-factoryParam]";
    private final SubnodeConfiguration configuration;
    private final ConfigurationNode node;

    public XMLBeanDeclaration(HierarchicalConfiguration hierarchicalConfiguration, String string) {
        this(hierarchicalConfiguration, string, false);
    }

    public XMLBeanDeclaration(HierarchicalConfiguration hierarchicalConfiguration, String string, boolean bl) {
        if (hierarchicalConfiguration == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        SubnodeConfiguration subnodeConfiguration = null;
        ConfigurationNode configurationNode = null;
        try {
            subnodeConfiguration = hierarchicalConfiguration.configurationAt(string);
            configurationNode = subnodeConfiguration.getRootNode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!bl || hierarchicalConfiguration.getMaxIndex(string) > 0) {
                throw illegalArgumentException;
            }
            subnodeConfiguration = hierarchicalConfiguration.configurationAt(null);
            configurationNode = new DefaultConfigurationNode();
        }
        this.node = configurationNode;
        this.configuration = subnodeConfiguration;
        this.initSubnodeConfiguration(this.getConfiguration());
    }

    public XMLBeanDeclaration(HierarchicalConfiguration hierarchicalConfiguration) {
        this(hierarchicalConfiguration, (String)null);
    }

    public XMLBeanDeclaration(SubnodeConfiguration subnodeConfiguration, ConfigurationNode configurationNode) {
        if (subnodeConfiguration == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        if (configurationNode == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        this.node = configurationNode;
        this.configuration = subnodeConfiguration;
        this.initSubnodeConfiguration(subnodeConfiguration);
    }

    public SubnodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationNode getNode() {
        return this.node;
    }

    @Override
    public String getBeanFactoryName() {
        return this.getConfiguration().getString(ATTR_BEAN_FACTORY);
    }

    @Override
    public Object getBeanFactoryParameter() {
        return this.getConfiguration().getProperty(ATTR_FACTORY_PARAM);
    }

    @Override
    public String getBeanClassName() {
        return this.getConfiguration().getString(ATTR_BEAN_CLASS);
    }

    @Override
    public Map<String, Object> getBeanProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (ConfigurationNode configurationNode : this.getNode().getAttributes()) {
            if (this.isReservedNode(configurationNode)) continue;
            hashMap.put(configurationNode.getName(), this.interpolate(configurationNode.getValue()));
        }
        return hashMap;
    }

    @Override
    public Map<String, Object> getNestedBeanDeclarations() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (ConfigurationNode configurationNode : this.getNode().getChildren()) {
            if (this.isReservedNode(configurationNode)) continue;
            if (hashMap.containsKey(configurationNode.getName())) {
                List<BeanDeclaration> list;
                Object v = hashMap.get(configurationNode.getName());
                if (v instanceof List) {
                    List list2 = (List)v;
                    list = list2;
                } else {
                    list = new ArrayList();
                    list.add((BeanDeclaration)v);
                    hashMap.put(configurationNode.getName(), list);
                }
                list.add(this.createBeanDeclaration(configurationNode));
                continue;
            }
            hashMap.put(configurationNode.getName(), this.createBeanDeclaration(configurationNode));
        }
        return hashMap;
    }

    protected Object interpolate(Object object) {
        return PropertyConverter.interpolate(object, this.getConfiguration().getParent());
    }

    protected boolean isReservedNode(ConfigurationNode configurationNode) {
        return configurationNode.isAttribute() && (configurationNode.getName() == null || configurationNode.getName().startsWith(RESERVED_PREFIX));
    }

    protected BeanDeclaration createBeanDeclaration(ConfigurationNode configurationNode) {
        List<HierarchicalConfiguration> list = this.getConfiguration().configurationsAt(configurationNode.getName());
        if (list.size() == 1) {
            return new XMLBeanDeclaration((SubnodeConfiguration)list.get(0), configurationNode);
        }
        for (SubnodeConfiguration subnodeConfiguration : list) {
            if (!subnodeConfiguration.getRootNode().equals(configurationNode)) continue;
            return new XMLBeanDeclaration(subnodeConfiguration, configurationNode);
        }
        throw new ConfigurationRuntimeException("Unable to match node for " + configurationNode.getName());
    }

    private void initSubnodeConfiguration(SubnodeConfiguration subnodeConfiguration) {
        subnodeConfiguration.setThrowExceptionOnMissing(false);
        subnodeConfiguration.setExpressionEngine(null);
    }
}

