/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ObjectFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.spring.beans.BeanMethodTransformer;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansConfig;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTargetScope;
import java.security.ProtectionDomain;

public class SpringBeansPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    public static final String SPRING_BEANS_MARK_ERROR = "profiler.spring.beans.mark.error";
    public static final String ENABLE = "profiler.spring.beans";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        boolean enable = context.getConfig().readBoolean(ENABLE, true);
        if (!enable) {
            return;
        }
        SpringBeansConfig config = new SpringBeansConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SpringBeans targets=" + config.getTargets());
        }
        if (config.hasTarget(SpringBeansTargetScope.COMPONENT_SCAN)) {
            this.addClassPathDefinitionScannerTransformer(context);
        }
        if (config.hasTarget(SpringBeansTargetScope.POST_PROCESSOR)) {
            this.addAbstractAutowireCapableBeanFactoryTransformer(context);
        }
    }

    private void addAbstractAutowireCapableBeanFactoryTransformer(ProfilerPluginSetupContext context) {
        final ProfilerConfig config = context.getConfig();
        final boolean errorMark = config.readBoolean(SPRING_BEANS_MARK_ERROR, false);
        this.transformTemplate.transform("org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                BeanMethodTransformer beanTransformer = new BeanMethodTransformer(errorMark);
                ObjectFactory beanFilterFactory = ObjectFactory.byStaticFactory((String)"com.navercorp.pinpoint.plugin.spring.beans.interceptor.TargetBeanFilter", (String)"of", (Object[])new Object[]{config});
                InstrumentMethod createBeanInstance = target.getDeclaredMethod("createBeanInstance", new String[]{"java.lang.String", "org.springframework.beans.factory.support.RootBeanDefinition", "java.lang.Object[]"});
                createBeanInstance.addInterceptor("com.navercorp.pinpoint.plugin.spring.beans.interceptor.CreateBeanInstanceInterceptor", VarArgs.va((Object[])new Object[]{beanTransformer, beanFilterFactory}));
                InstrumentMethod postProcessor = target.getDeclaredMethod("applyBeanPostProcessorsBeforeInstantiation", new String[]{"java.lang.Class", "java.lang.String"});
                postProcessor.addInterceptor("com.navercorp.pinpoint.plugin.spring.beans.interceptor.PostProcessorInterceptor", VarArgs.va((Object[])new Object[]{beanTransformer, beanFilterFactory}));
                return target.toBytecode();
            }
        });
    }

    private void addClassPathDefinitionScannerTransformer(ProfilerPluginSetupContext context) {
        final ProfilerConfig config = context.getConfig();
        final boolean errorMark = config.readBoolean(SPRING_BEANS_MARK_ERROR, false);
        this.transformTemplate.transform("org.springframework.context.annotation.ClassPathBeanDefinitionScanner", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                BeanMethodTransformer beanTransformer = new BeanMethodTransformer(errorMark);
                ObjectFactory beanFilterFactory = ObjectFactory.byStaticFactory((String)"com.navercorp.pinpoint.plugin.spring.beans.interceptor.TargetBeanFilter", (String)"of", (Object[])new Object[]{config});
                InstrumentMethod method = target.getDeclaredMethod("doScan", new String[]{"java.lang.String[]"});
                method.addInterceptor("com.navercorp.pinpoint.plugin.spring.beans.interceptor.ClassPathDefinitionScannerDoScanInterceptor", VarArgs.va((Object[])new Object[]{loader, beanTransformer, beanFilterFactory}));
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

