/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.akka.http.interceptor;

import akka.http.javadsl.model.HttpMethod;
import akka.http.javadsl.model.HttpRequest;
import akka.http.scaladsl.server.RequestContextImpl;
import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyHttpHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.sampler.SamplingFlagUtils;
import com.navercorp.pinpoint.bootstrap.util.NetworkUtils;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.akka.http.AkkaHttpConfig;
import com.navercorp.pinpoint.plugin.akka.http.AkkaHttpConstants;
import com.navercorp.pinpoint.plugin.akka.http.HttpRequestAdaptor;
import com.navercorp.pinpoint.plugin.akka.http.interceptor.AkkaHttpServerMethodDescriptor;

public class DirectivesInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(DirectivesInterceptor.class);
    private final boolean isTrace = this.logger.isTraceEnabled();
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private static final AkkaHttpServerMethodDescriptor AKKA_HTTP_SERVER_METHOD_DESCRIPTOR = new AkkaHttpServerMethodDescriptor();
    private final ProxyHttpHeaderRecorder<HttpRequest> proxyHttpHeaderRecorder;
    private final RequestAdaptor<HttpRequest> requestAdaptor;
    private final Filter<String> excludeHttpMethodFilter;
    private final Filter<String> excludeUrlFilter;

    public DirectivesInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
        AkkaHttpConfig config = new AkkaHttpConfig(traceContext.getProfilerConfig());
        this.excludeUrlFilter = config.getExcludeUrlFilter();
        this.excludeHttpMethodFilter = config.getExcludeHttpMethodFilter();
        this.requestAdaptor = new HttpRequestAdaptor(config);
        this.proxyHttpHeaderRecorder = new ProxyHttpHeaderRecorder(traceContext.getProfilerConfig().isProxyHttpHeaderEnable(), this.requestAdaptor);
        traceContext.cacheApi((MethodDescriptor)AKKA_HTTP_SERVER_METHOD_DESCRIPTOR);
    }

    public void before(Object target, Object[] args) {
        int requestContextIndex;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((requestContextIndex = this.getArgsIndexOfRequestContext(args)) == -1) {
            return;
        }
        if (this.traceContext.currentTraceObject() != null) {
            return;
        }
        RequestContextImpl requestContext = (RequestContextImpl)args[requestContextIndex];
        if (!(requestContext instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid requestContext. Need metadata accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return;
        }
        akka.http.scaladsl.model.HttpRequest request = requestContext.request();
        Trace trace = this.createTrace((HttpRequest)request);
        if (trace == null || !trace.canSampled()) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(AkkaHttpConstants.AKKA_HTTP_SERVER_INTERNAL);
        AsyncContext asyncContext = recorder.recordNextAsyncContext(true);
        ((AsyncContextAccessor)requestContext)._$PINPOINT$_setAsyncContext(asyncContext);
        if (this.isDebug) {
            this.logger.debug("Set closeable-AsyncContext {}", (Object)asyncContext);
        }
    }

    private int getArgsIndexOfRequestContext(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof RequestContextImpl)) continue;
            return i;
        }
        return -1;
    }

    private Trace createTrace(HttpRequest request) {
        if (request == null) {
            return null;
        }
        String requestUri = String.valueOf(request.getUri());
        if (requestUri != null && this.excludeUrlFilter.filter((Object)requestUri)) {
            if (this.isTrace) {
                this.logger.trace("filter requestURI:{}", (Object)requestUri);
            }
            return null;
        }
        HttpMethod method = request.method();
        if (method != null && this.excludeHttpMethodFilter.filter((Object)method.value())) {
            if (this.isTrace) {
                this.logger.trace("filter http method:{}", (Object)method.value());
            }
            return null;
        }
        boolean sampling = this.samplingEnable(request);
        if (!sampling) {
            Trace trace = this.traceContext.disableSampling();
            if (this.isDebug) {
                this.logger.debug("Remote call sampling flag found. skip trace requestUrl:{}", (Object)requestUri);
            }
            return trace;
        }
        TraceId traceId = this.populateTraceIdFromRequest(request);
        if (traceId != null) {
            Trace trace = this.traceContext.continueAsyncTraceObject(traceId);
            if (trace.canSampled()) {
                SpanRecorder recorder = trace.getSpanRecorder();
                this.recordRootSpan(recorder, request);
                if (this.isDebug) {
                    this.logger.debug("TraceID exist. continue trace. traceId:{}, requestUrl:{}", (Object)traceId, (Object)requestUri);
                }
            } else if (this.isDebug) {
                this.logger.debug("TraceID exist. camSampled is false. skip trace. traceId:{}, requestUrl:{}", (Object)traceId, (Object)requestUri);
            }
            return trace;
        }
        Trace trace = this.traceContext.newAsyncTraceObject();
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            this.recordRootSpan(recorder, request);
        } else if (this.isDebug) {
            this.logger.debug("Sampling is disabled");
        }
        return trace;
    }

    private boolean samplingEnable(HttpRequest request) {
        String samplingFlag = this.requestAdaptor.getHeader((Object)request, Header.HTTP_SAMPLED.toString());
        if (this.isDebug) {
            this.logger.debug("SamplingFlag={}", (Object)samplingFlag);
        }
        return SamplingFlagUtils.isSamplingFlag((String)samplingFlag);
    }

    private TraceId populateTraceIdFromRequest(HttpRequest request) {
        String transactionId = this.requestAdaptor.getHeader((Object)request, Header.HTTP_TRACE_ID.toString());
        if (transactionId != null) {
            long parentSpanID = NumberUtils.parseLong((String)this.requestAdaptor.getHeader((Object)request, Header.HTTP_PARENT_SPAN_ID.toString()), (long)-1L);
            long spanID = NumberUtils.parseLong((String)this.requestAdaptor.getHeader((Object)request, Header.HTTP_SPAN_ID.toString()), (long)-1L);
            short flags = NumberUtils.parseShort((String)this.requestAdaptor.getHeader((Object)request, Header.HTTP_FLAGS.toString()), (short)0);
            TraceId id = this.traceContext.createTraceId(transactionId, parentSpanID, spanID, flags);
            if (this.isDebug) {
                this.logger.debug("TraceID exist. continue trace. {}", (Object)id);
            }
            return id;
        }
        return null;
    }

    private void recordRootSpan(SpanRecorder recorder, HttpRequest request) {
        String remoteAddress;
        recorder.recordServiceType(AkkaHttpConstants.AKKA_HTTP_SERVER);
        String requestURL = this.requestAdaptor.getRpcName((Object)request);
        if (StringUtils.hasLength((String)requestURL)) {
            recorder.recordRpcName(requestURL);
        }
        if (StringUtils.hasLength((String)(remoteAddress = this.requestAdaptor.getRemoteAddress((Object)request)))) {
            recorder.recordRemoteAddress(remoteAddress);
        }
        this.proxyHttpHeaderRecorder.record(recorder, (Object)request);
        if (!recorder.isRoot()) {
            this.recordParentInfo(recorder, request);
        }
        recorder.recordApi((MethodDescriptor)AKKA_HTTP_SERVER_METHOD_DESCRIPTOR);
    }

    private void recordParentInfo(SpanRecorder recorder, HttpRequest request) {
        String parentApplicationName = this.requestAdaptor.getHeader((Object)request, Header.HTTP_PARENT_APPLICATION_NAME.toString());
        if (parentApplicationName != null) {
            String host = this.requestAdaptor.getAcceptorHost((Object)request);
            if (host != null) {
                recorder.recordAcceptorHost(host);
            } else {
                String requestURL = String.valueOf(request.getUri());
                recorder.recordAcceptorHost(NetworkUtils.getHostFromURL((String)requestURL));
            }
            String type = this.requestAdaptor.getHeader((Object)request, Header.HTTP_PARENT_APPLICATION_TYPE.toString());
            short parentApplicationType = NumberUtils.parseShort((String)type, (short)ServiceType.UNDEFINED.getCode());
            recorder.recordParentApplication(parentApplicationName, parentApplicationType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (this.getArgsIndexOfRequestContext(args) == -1) {
            return;
        }
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.deleteTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
        finally {
            trace.traceBlockEnd();
            this.deleteTrace(trace);
        }
    }

    private void deleteTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
    }
}

