/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.commons.dbcp;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.plugin.commons.dbcp.CommonsDbcpConfig;
import java.security.ProtectionDomain;

public class CommonsDbcpPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private CommonsDbcpConfig config;
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        this.config = new CommonsDbcpConfig(context.getConfig());
        if (!this.config.isPluginEnable()) {
            this.logger.info("Disable commons dbcp option. 'profiler.jdbc.dbcp=false'");
            return;
        }
        this.addBasicDataSourceTransformer();
        if (this.config.isProfileClose()) {
            this.addPoolGuardConnectionWrapperTransformer();
        }
    }

    private void addPoolGuardConnectionWrapperTransformer() {
        this.transformTemplate.transform("org.apache.commons.dbcp.PoolingDataSource$PoolGuardConnectionWrapper", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp.interceptor.DataSourceCloseConnectionInterceptor", "DBCP_SCOPE");
                return target.toBytecode();
            }
        });
    }

    private void addBasicDataSourceTransformer() {
        this.transformTemplate.transform("org.apache.commons.dbcp.BasicDataSource", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (CommonsDbcpPlugin.this.isAvailableDataSourceMonitor(target)) {
                    target.addField("com.navercorp.pinpoint.plugin.commons.dbcp.DataSourceMonitorAccessor");
                    InstrumentMethod defaultConstructor = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[0]);
                    defaultConstructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp.interceptor.DataSourceConstructorInterceptor", "DBCP_SCOPE");
                    InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                    closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp.interceptor.DataSourceCloseInterceptor", "DBCP_SCOPE");
                }
                InstrumentMethod getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[0]);
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp.interceptor.DataSourceGetConnectionInterceptor", "DBCP_SCOPE");
                getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[]{"java.lang.String", "java.lang.String"});
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp.interceptor.DataSourceGetConnectionInterceptor", "DBCP_SCOPE");
                return target.toBytecode();
            }
        });
    }

    private boolean isAvailableDataSourceMonitor(InstrumentClass target) {
        boolean hasMethod = target.hasMethod("getUrl", new String[0]);
        if (!hasMethod) {
            return false;
        }
        hasMethod = target.hasMethod("getNumActive", new String[0]);
        if (!hasMethod) {
            return false;
        }
        hasMethod = target.hasMethod("getMaxActive", new String[0]);
        return hasMethod;
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

