/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.instrument.GuardInstrumentContext;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerLoader;
import com.navercorp.pinpoint.profiler.plugin.DefaultProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.plugin.GuardProfilerPluginContext;
import com.navercorp.pinpoint.profiler.plugin.PluginInstrumentContext;
import com.navercorp.pinpoint.profiler.plugin.PluginSetup;
import com.navercorp.pinpoint.profiler.plugin.SetupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginSetup
implements PluginSetup {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;

    public DefaultPluginSetup(ProfilerConfig profilerConfig, InstrumentEngine instrumentEngine, DynamicTransformTrigger dynamicTransformTrigger) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (instrumentEngine == null) {
            throw new NullPointerException("instrumentEngine must not be null");
        }
        if (dynamicTransformTrigger == null) {
            throw new NullPointerException("dynamicTransformTrigger must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.instrumentEngine = instrumentEngine;
        this.dynamicTransformTrigger = dynamicTransformTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetupResult setupPlugin(ProfilerPlugin profilerPlugin, ClassInjector classInjector) {
        ClassFileTransformerLoader transformerRegistry = new ClassFileTransformerLoader(this.profilerConfig, this.dynamicTransformTrigger);
        DefaultProfilerPluginSetupContext setupContext = new DefaultProfilerPluginSetupContext(this.profilerConfig);
        GuardProfilerPluginContext guardSetupContext = new GuardProfilerPluginContext(setupContext);
        PluginInstrumentContext instrumentContext = new PluginInstrumentContext(this.profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger, classInjector, transformerRegistry);
        GuardInstrumentContext guardInstrumentContext = this.preparePlugin(profilerPlugin, instrumentContext);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} Plugin setup", (Object)profilerPlugin.getClass().getName());
            }
            profilerPlugin.setup((ProfilerPluginSetupContext)guardSetupContext);
        }
        finally {
            guardSetupContext.close();
            guardInstrumentContext.close();
        }
        SetupResult setupResult = new SetupResult(setupContext, transformerRegistry);
        return setupResult;
    }

    private GuardInstrumentContext preparePlugin(ProfilerPlugin plugin, InstrumentContext instrumentContext) {
        GuardInstrumentContext guardInstrumentContext = new GuardInstrumentContext(instrumentContext);
        if (plugin instanceof TransformTemplateAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}.setTransformTemplate", (Object)plugin.getClass().getName());
            }
            TransformTemplate transformTemplate = new TransformTemplate((InstrumentContext)guardInstrumentContext);
            ((TransformTemplateAware)plugin).setTransformTemplate(transformTemplate);
        } else if (plugin instanceof MatchableTransformTemplateAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}.setTransformTemplate", (Object)plugin.getClass().getName());
            }
            MatchableTransformTemplate transformTemplate = new MatchableTransformTemplate((InstrumentContext)guardInstrumentContext);
            ((MatchableTransformTemplateAware)plugin).setTransformTemplate(transformTemplate);
        }
        return guardInstrumentContext;
    }
}

