/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.httpclient4.HttpCallContext;

public class HttpRequestExecutorDoSendRequestAndDoReceiveResponseMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final InterceptorScope interceptorScope;

    public HttpRequestExecutorDoSendRequestAndDoReceiveResponseMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(invocation);
        if (attachment instanceof HttpCallContext) {
            HttpCallContext callContext = (HttpCallContext)attachment;
            if (this.methodDescriptor.getMethodName().equals("doSendRequest")) {
                callContext.setWriteBeginTime(System.currentTimeMillis());
            } else {
                callContext.setReadBeginTime(System.currentTimeMillis());
            }
            if (this.isDebug) {
                this.logger.debug("Set call context {}", (Object)callContext);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(invocation);
        if (attachment instanceof HttpCallContext) {
            HttpCallContext callContext = (HttpCallContext)attachment;
            if (this.methodDescriptor.getMethodName().equals("doSendRequest")) {
                callContext.setWriteEndTime(System.currentTimeMillis());
                callContext.setWriteFail(throwable != null);
            } else {
                callContext.setReadEndTime(System.currentTimeMillis());
                callContext.setReadFail(throwable != null);
            }
            if (this.isDebug) {
                this.logger.debug("Set call context {}", (Object)callContext);
            }
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }
}

