/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportOperationMessageListener
implements MessageListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final UnsupportOperationMessageListener INSTANCE = new UnsupportOperationMessageListener();

    @Override
    public void handleSend(SendPacket sendPacket, PinpointSocket pinpointSocket) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Unsupported handleSend method");
        errorMessage.append("packet:").append(sendPacket);
        errorMessage.append(", remote::").append(pinpointSocket.getRemoteAddress());
        throw new UnsupportedOperationException(errorMessage.toString());
    }

    @Override
    public void handleRequest(RequestPacket requestPacket, PinpointSocket pinpointSocket) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Unsupported handleRequest method");
        errorMessage.append("packet:").append(requestPacket);
        errorMessage.append(", remote::").append(pinpointSocket.getRemoteAddress());
        throw new UnsupportedOperationException(errorMessage.toString());
    }

    public static UnsupportOperationMessageListener getInstance() {
        return INSTANCE;
    }
}

