/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.id.ListenableAsyncState;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

@InterfaceAudience.LimitedPrivate(value={"vert.x"})
public class SpanAsyncStateListener
implements ListenableAsyncState.AsyncStateListener {
    private static final AtomicIntegerFieldUpdater<SpanAsyncStateListener> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SpanAsyncStateListener.class, "closed");
    private static final int OPEN = 0;
    private static final int CLOSED = 1;
    private volatile int closed = 0;
    private final Span span;
    private final StorageFactory storageFactory;

    SpanAsyncStateListener(Span span, StorageFactory storageFactory) {
        this.span = (Span)Assert.requireNonNull((Object)span, (String)"span must not be null");
        this.storageFactory = (StorageFactory)Assert.requireNonNull((Object)storageFactory, (String)"storageFactory must not be null");
    }

    @Override
    public void finish() {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            if (this.span.isTimeRecording()) {
                this.span.markAfterTime();
            }
            TraceRoot traceRoot = this.span.getTraceRoot();
            Storage storage = this.storageFactory.createStorage(traceRoot);
            storage.store(this.span);
            storage.close();
        }
    }
}

