/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.arcus;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class ArcusPluginConfig {
    private final boolean arcus;
    private final boolean arcusKeyTrace;
    private final boolean arcusAsync;
    private final boolean memcached;
    private final boolean memcachedKeyTrace;
    private final boolean memcachedAsync;

    public ArcusPluginConfig(ProfilerConfig src) {
        this.arcus = src.readBoolean("profiler.arcus", true);
        this.arcusKeyTrace = src.readBoolean("profiler.arcus.keytrace", false);
        this.arcusAsync = src.readBoolean("profiler.arcus.async", true);
        this.memcached = src.readBoolean("profiler.memcached", true);
        this.memcachedKeyTrace = src.readBoolean("profiler.memcached.keytrace", false);
        this.memcachedAsync = src.readBoolean("profiler.memcached.async", true);
    }

    public boolean isArcus() {
        return this.arcus;
    }

    public boolean isArcusKeyTrace() {
        return this.arcusKeyTrace;
    }

    public boolean isMemcached() {
        return this.memcached;
    }

    public boolean isMemcachedKeyTrace() {
        return this.memcachedKeyTrace;
    }

    public boolean isArcusAsync() {
        return this.arcusAsync;
    }

    public boolean isMemcachedAsync() {
        return this.memcachedAsync;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArcusPluginConfig{");
        sb.append("arcus=").append(this.arcus);
        sb.append(", arcusKeyTrace=").append(this.arcusKeyTrace);
        sb.append(", arcusAsync=").append(this.arcusAsync);
        sb.append(", memcached=").append(this.memcached);
        sb.append(", memcachedKeyTrace=").append(this.memcachedKeyTrace);
        sb.append(", memcachedAsync=").append(this.memcachedAsync);
        sb.append('}');
        return sb.toString();
    }
}

