/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.user.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.ServiceType;

public class MQExternalClientHandlerInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected static final String ASYNC_TRACE_SCOPE = "##ASYNC_TRACE_SCOPE";
    protected final MethodDescriptor methodDescriptor;

    public MQExternalClientHandlerInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        this.methodDescriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        block5: {
            AsyncContext asyncContext = this.getAsyncContext(args);
            if (asyncContext == null) {
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            this.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(ServiceType.INTERNAL_METHOD);
                recorder.recordApi(this.methodDescriptor);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        AsyncContext asyncContext = this.getAsyncContext(args);
        if (asyncContext == null) {
            return;
        }
        Trace trace = asyncContext.currentAsyncTraceObject();
        if (trace == null) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncContext(trace, asyncContext);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (throwable != null) {
                recorder.recordException(throwable);
            }
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (this.isAsyncTraceDestination(trace)) {
                this.deleteAsyncContext(trace, asyncContext);
            }
        }
    }

    private AsyncContext getAsyncContext(Object[] args) {
        if (args == null || args.length < 1) {
            return null;
        }
        for (Object arg : args) {
            if (!(arg instanceof AsyncContextAccessor)) continue;
            return AsyncContextAccessorUtils.getAsyncContext((Object)arg);
        }
        return null;
    }

    private Trace getAsyncTrace(AsyncContext asyncContext) {
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to continue async trace. 'result is null'");
            }
            return null;
        }
        if (this.isDebug) {
            this.logger.debug("getAsyncTrace() trace {}, asyncContext={}", (Object)trace, (Object)asyncContext);
        }
        return trace;
    }

    private void deleteAsyncContext(Trace trace, AsyncContext asyncContext) {
        if (this.isDebug) {
            this.logger.debug("Delete async trace {}.", (Object)trace);
        }
        trace.close();
        asyncContext.close();
    }

    private void entryAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            scope.tryEnter();
        }
    }

    private boolean leaveAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isAsyncTraceDestination(Trace trace) {
        if (!trace.isAsync()) {
            return false;
        }
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        return scope != null && !scope.isActive();
    }
}

